/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.common.util;

import java.lang.reflect.Modifier;
import java.util.Collection;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.common.mapper.NitriteMapper;
import org.dizitart.no2.common.util.ObjectUtils;
import org.dizitart.no2.common.util.StringUtils;
import org.dizitart.no2.exceptions.IndexingException;
import org.dizitart.no2.exceptions.InvalidOperationException;
import org.dizitart.no2.exceptions.ValidationException;

public class ValidationUtils {
    private ValidationUtils() {
    }

    public static void notEmpty(String value, String message) {
        if (StringUtils.isNullOrEmpty(value)) {
            throw new ValidationException(message);
        }
    }

    public static void notEmpty(CharSequence value, String message) {
        if (StringUtils.isNullOrEmpty(value)) {
            throw new ValidationException(message);
        }
    }

    public static void notEmpty(Collection<?> value, String message) {
        if (value.isEmpty()) {
            throw new ValidationException(message);
        }
    }

    public static <T> void notEmpty(T[] value, String message) {
        if (value.length == 0) {
            throw new ValidationException(message);
        }
    }

    public static void notNull(Object value, String message) {
        if (value == null) {
            throw new ValidationException(message);
        }
    }

    public static <T> void containsNull(T[] array, String message) {
        for (T element : array) {
            if (element != null) continue;
            throw new ValidationException(message);
        }
    }

    public static void validateIterableIndexField(Iterable<?> fieldValue, String field) {
        if (fieldValue != null) {
            for (Object value : fieldValue) {
                if (value == null) continue;
                ValidationUtils.validateArrayIndexItem(value, field);
            }
        }
    }

    public static void validateStringIterableIndexField(Iterable<?> fieldValue, String field) {
        if (fieldValue != null) {
            for (Object value : fieldValue) {
                if (value == null) continue;
                ValidationUtils.validateStringArrayItem(value, field);
            }
        }
    }

    public static void validateArrayIndexField(Object arrayValue, String field) {
        if (arrayValue != null) {
            Object[] array;
            for (Object value : array = ObjectUtils.convertToObjectArray(arrayValue)) {
                if (value == null) continue;
                ValidationUtils.validateArrayIndexItem(value, field);
            }
        }
    }

    public static void validateStringArrayIndexField(Object arrayValue, String field) {
        if (arrayValue != null) {
            Object[] array;
            for (Object value : array = ObjectUtils.convertToObjectArray(arrayValue)) {
                if (value == null) continue;
                ValidationUtils.validateStringArrayItem(value, field);
            }
        }
    }

    public static void validateFilterArrayField(Object arrayValue, String field) {
        if (arrayValue != null) {
            Object[] array;
            for (Object value : array = ObjectUtils.convertToObjectArray(arrayValue)) {
                if (value == null) continue;
                ValidationUtils.validateArrayFilterItem(value, field);
            }
        }
    }

    public static void validateFilterIterableField(Iterable<?> fieldValue, String field) {
        if (fieldValue != null) {
            for (Object value : fieldValue) {
                if (value == null) continue;
                ValidationUtils.validateArrayFilterItem(value, field);
            }
        }
    }

    public static void validateProjectionType(Class<?> type, NitriteMapper nitriteMapper) {
        Object value;
        try {
            value = ObjectUtils.newInstance(type, false, nitriteMapper);
        }
        catch (Exception e) {
            throw new ValidationException("Invalid projection type", e);
        }
        if (value == null) {
            throw new ValidationException("Invalid projection type");
        }
        Document document = (Document)nitriteMapper.tryConvert(value, Document.class);
        if (document == null || document.size() == 0) {
            throw new ValidationException("Cannot project to empty type " + type);
        }
    }

    public static void validateRepositoryType(Class<?> type, NitriteMapper nitriteMapper) {
        try {
            if (type.isInterface() || Modifier.isAbstract(type.getModifiers()) && !ObjectUtils.isBuiltInValueType(type)) {
                return;
            }
            Object value = ObjectUtils.newInstance(type, false, nitriteMapper);
            if (value == null) {
                throw new ValidationException("Cannot create new instance of type " + type);
            }
            Document document = (Document)nitriteMapper.tryConvert(value, Document.class);
            if (document == null || document.size() == 0) {
                throw new ValidationException("Cannot convert to document from type " + type);
            }
        }
        catch (Exception e) {
            throw new ValidationException("Invalid repository type", e);
        }
    }

    private static void validateArrayIndexItem(Object value, String field) {
        if (value instanceof Iterable || value.getClass().isArray()) {
            throw new InvalidOperationException("Nested iterables are not supported");
        }
        if (!(value instanceof Comparable)) {
            throw new IndexingException("Each value in the iterable field " + field + " must implement Comparable");
        }
    }

    private static void validateStringArrayItem(Object value, String field) {
        if (!(value instanceof String) && (value instanceof Iterable || value.getClass().isArray())) {
            throw new InvalidOperationException("Nested iterables are not supported");
        }
        if (!(value instanceof String)) {
            throw new IndexingException("Each value in the iterable field " + field + " must be a string");
        }
    }

    private static void validateArrayFilterItem(Object value, String field) {
        if (value instanceof Iterable || value.getClass().isArray()) {
            throw new InvalidOperationException("Nested array is not supported");
        }
        if (!(value instanceof Comparable)) {
            throw new IndexingException("Cannot filter using non comparable values " + field);
        }
    }
}

