/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.index;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import lombok.Generated;
import org.dizitart.no2.collection.FindPlan;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.DBNull;
import org.dizitart.no2.common.DBValue;
import org.dizitart.no2.common.FieldValues;
import org.dizitart.no2.common.Fields;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.common.util.IndexUtils;
import org.dizitart.no2.common.util.ObjectUtils;
import org.dizitart.no2.exceptions.IndexingException;
import org.dizitart.no2.filters.ComparableFilter;
import org.dizitart.no2.index.IndexDescriptor;
import org.dizitart.no2.index.IndexMap;
import org.dizitart.no2.index.IndexScanner;
import org.dizitart.no2.index.NitriteIndex;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.store.NitriteStore;

public class CompoundIndex
implements NitriteIndex {
    private final IndexDescriptor indexDescriptor;
    private final NitriteStore<?> nitriteStore;

    public CompoundIndex(IndexDescriptor indexDescriptor, NitriteStore<?> nitriteStore) {
        this.indexDescriptor = indexDescriptor;
        this.nitriteStore = nitriteStore;
    }

    @Override
    public void write(FieldValues fieldValues) {
        block3: {
            NitriteMap<DBValue, NavigableMap<DBValue, ?>> indexMap;
            Object firstValue;
            block5: {
                Object[] array;
                block4: {
                    block2: {
                        Fields fields = fieldValues.getFields();
                        List<String> fieldNames = fields.getFieldNames();
                        String firstField = fieldNames.get(0);
                        firstValue = fieldValues.get(firstField);
                        this.validateIndexField(firstValue, firstField);
                        indexMap = this.findIndexMap();
                        if (firstValue != null) break block2;
                        this.addIndexElement(indexMap, fieldValues, DBNull.getInstance());
                        break block3;
                    }
                    if (!(firstValue instanceof Comparable)) break block4;
                    DBValue dbValue = new DBValue((Comparable)firstValue);
                    this.addIndexElement(indexMap, fieldValues, dbValue);
                    break block3;
                }
                if (!firstValue.getClass().isArray()) break block5;
                for (Object item : array = ObjectUtils.convertToObjectArray(firstValue)) {
                    DBValue dbValue = item == null ? DBNull.getInstance() : new DBValue((Comparable)item);
                    this.addIndexElement(indexMap, fieldValues, dbValue);
                }
                break block3;
            }
            if (!(firstValue instanceof Iterable)) break block3;
            Iterable iterable = (Iterable)firstValue;
            for (Object item : iterable) {
                DBValue dbValue = item != null ? new DBValue((Comparable)item) : DBNull.getInstance();
                this.addIndexElement(indexMap, fieldValues, dbValue);
            }
        }
    }

    @Override
    public void remove(FieldValues fieldValues) {
        block3: {
            NitriteMap<DBValue, NavigableMap<DBValue, ?>> indexMap;
            Object firstValue;
            block5: {
                Object[] array;
                block4: {
                    block2: {
                        Fields fields = fieldValues.getFields();
                        List<String> fieldNames = fields.getFieldNames();
                        String firstField = fieldNames.get(0);
                        firstValue = fieldValues.get(firstField);
                        this.validateIndexField(firstValue, firstField);
                        indexMap = this.findIndexMap();
                        if (firstValue != null) break block2;
                        this.removeIndexElement(indexMap, fieldValues, DBNull.getInstance());
                        break block3;
                    }
                    if (!(firstValue instanceof Comparable)) break block4;
                    DBValue dbValue = new DBValue((Comparable)firstValue);
                    this.removeIndexElement(indexMap, fieldValues, dbValue);
                    break block3;
                }
                if (!firstValue.getClass().isArray()) break block5;
                for (Object item : array = ObjectUtils.convertToObjectArray(firstValue)) {
                    DBValue dbValue = item == null ? DBNull.getInstance() : new DBValue((Comparable)item);
                    this.removeIndexElement(indexMap, fieldValues, dbValue);
                }
                break block3;
            }
            if (!(firstValue instanceof Iterable)) break block3;
            Iterable iterable = (Iterable)firstValue;
            for (Object item : iterable) {
                DBValue dbValue = item != null ? new DBValue((Comparable)item) : DBNull.getInstance();
                this.removeIndexElement(indexMap, fieldValues, dbValue);
            }
        }
    }

    @Override
    public void drop() {
        NitriteMap<DBValue, NavigableMap<DBValue, ?>> indexMap = this.findIndexMap();
        indexMap.clear();
        indexMap.drop();
    }

    @Override
    public LinkedHashSet<NitriteId> findNitriteIds(FindPlan findPlan) {
        if (findPlan.getIndexScanFilter() == null) {
            return new LinkedHashSet<NitriteId>();
        }
        NitriteMap<DBValue, NavigableMap<DBValue, ?>> indexMap = this.findIndexMap();
        return this.scanIndex(findPlan, indexMap);
    }

    private void addIndexElement(NitriteMap<DBValue, NavigableMap<DBValue, ?>> indexMap, FieldValues fieldValues, DBValue element) {
        NavigableMap<DBValue, ?> subMap = indexMap.get(element);
        if (subMap == null) {
            subMap = new ConcurrentSkipListMap();
        }
        this.populateSubMap(subMap, fieldValues, 1);
        indexMap.put(element, subMap);
    }

    private void removeIndexElement(NitriteMap<DBValue, NavigableMap<DBValue, ?>> indexMap, FieldValues fieldValues, DBValue element) {
        NavigableMap<DBValue, ?> subMap = indexMap.get(element);
        if (subMap != null && !subMap.isEmpty()) {
            this.deleteFromSubMap(subMap, fieldValues, 1);
            indexMap.put(element, subMap);
        }
    }

    private void populateSubMap(NavigableMap subMap, FieldValues fieldValues, int depth) {
        DBValue dbValue;
        if (depth >= fieldValues.getValues().size()) {
            return;
        }
        Pair<String, Object> pair = fieldValues.getValues().get(depth);
        Object value = pair.getSecond();
        if (value == null) {
            dbValue = DBNull.getInstance();
        } else {
            if (Iterable.class.isAssignableFrom(value.getClass()) || value.getClass().isArray()) {
                throw new IndexingException("Compound multikey index is supported on the first field of the index only");
            }
            if (!(value instanceof Comparable)) {
                throw new IndexingException(value + " is not a comparable type");
            }
            dbValue = new DBValue((Comparable)value);
        }
        if (depth == fieldValues.getValues().size() - 1) {
            List<NitriteId> nitriteIds = (List<NitriteId>)subMap.get(dbValue);
            nitriteIds = this.addNitriteIds(nitriteIds, fieldValues);
            subMap.put(dbValue, nitriteIds);
        } else {
            ConcurrentSkipListMap subMap2 = (ConcurrentSkipListMap)subMap.get(dbValue);
            if (subMap2 == null) {
                subMap2 = new ConcurrentSkipListMap();
            }
            subMap.put(dbValue, subMap2);
            this.populateSubMap(subMap2, fieldValues, depth + 1);
        }
    }

    private void deleteFromSubMap(NavigableMap subMap, FieldValues fieldValues, int depth) {
        DBValue dbValue;
        Pair<String, Object> pair = fieldValues.getValues().get(depth);
        Object value = pair.getSecond();
        if (value == null) {
            dbValue = DBNull.getInstance();
        } else {
            if (!(value instanceof Comparable)) {
                return;
            }
            dbValue = new DBValue((Comparable)value);
        }
        if (depth == fieldValues.getValues().size() - 1) {
            List<NitriteId> nitriteIds = (List<NitriteId>)subMap.get(dbValue);
            if ((nitriteIds = this.removeNitriteIds(nitriteIds, fieldValues)) == null || nitriteIds.isEmpty()) {
                subMap.remove(dbValue);
            } else {
                subMap.put(dbValue, nitriteIds);
            }
        } else {
            NavigableMap subMap2 = (NavigableMap)subMap.get(dbValue);
            if (subMap2 == null) {
                return;
            }
            this.deleteFromSubMap(subMap2, fieldValues, depth + 1);
            subMap.put(dbValue, subMap2);
        }
    }

    private NitriteMap<DBValue, NavigableMap<DBValue, ?>> findIndexMap() {
        String mapName = IndexUtils.deriveIndexMapName(this.indexDescriptor);
        return this.nitriteStore.openMap(mapName, DBValue.class, ConcurrentSkipListMap.class);
    }

    private LinkedHashSet<NitriteId> scanIndex(FindPlan findPlan, NitriteMap<DBValue, NavigableMap<DBValue, ?>> indexMap) {
        List<ComparableFilter> filters = findPlan.getIndexScanFilter().getFilters();
        IndexMap iMap = new IndexMap(indexMap);
        IndexScanner indexScanner = new IndexScanner(iMap);
        return indexScanner.doScan(filters, findPlan.getIndexScanOrder());
    }

    @Override
    @Generated
    public IndexDescriptor getIndexDescriptor() {
        return this.indexDescriptor;
    }
}

