/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.index;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.DBNull;
import org.dizitart.no2.common.DBValue;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.store.NitriteMap;

public class IndexMap {
    private NitriteMap<DBValue, ?> nitriteMap;
    private NavigableMap<DBValue, ?> navigableMap;
    private boolean reverseScan;

    public IndexMap(NitriteMap<DBValue, ?> nitriteMap) {
        this.nitriteMap = nitriteMap;
    }

    public IndexMap(NavigableMap<DBValue, ?> navigableMap) {
        this.navigableMap = navigableMap;
    }

    public <T extends Comparable<T>> T lowerKey(T key) {
        DBValue dbKey;
        DBValue dBValue = dbKey = key == null ? DBNull.getInstance() : new DBValue(key);
        if (!this.reverseScan) {
            if (this.nitriteMap != null) {
                dbKey = this.nitriteMap.lowerKey(dbKey);
            } else if (this.navigableMap != null) {
                dbKey = this.navigableMap.lowerKey(dbKey);
            }
        } else if (this.nitriteMap != null) {
            dbKey = this.nitriteMap.higherKey(dbKey);
        } else if (this.navigableMap != null) {
            dbKey = this.navigableMap.higherKey(dbKey);
        }
        return (T)(dbKey == null || dbKey instanceof DBNull ? null : dbKey.getValue());
    }

    public <T extends Comparable<T>> T higherKey(T key) {
        DBValue dbKey;
        DBValue dBValue = dbKey = key == null ? DBNull.getInstance() : new DBValue(key);
        if (!this.reverseScan) {
            if (this.nitriteMap != null) {
                dbKey = this.nitriteMap.higherKey(dbKey);
            } else if (this.navigableMap != null) {
                dbKey = this.navigableMap.higherKey(dbKey);
            }
        } else if (this.nitriteMap != null) {
            dbKey = this.nitriteMap.lowerKey(dbKey);
        } else if (this.navigableMap != null) {
            dbKey = this.navigableMap.lowerKey(dbKey);
        }
        return (T)(dbKey == null || dbKey instanceof DBNull ? null : dbKey.getValue());
    }

    public <T extends Comparable<T>> T ceilingKey(T key) {
        DBValue dbKey;
        DBValue dBValue = dbKey = key == null ? DBNull.getInstance() : new DBValue(key);
        if (!this.reverseScan) {
            if (this.nitriteMap != null) {
                dbKey = this.nitriteMap.ceilingKey(dbKey);
            } else if (this.navigableMap != null) {
                dbKey = this.navigableMap.ceilingKey(dbKey);
            }
        } else if (this.nitriteMap != null) {
            dbKey = this.nitriteMap.floorKey(dbKey);
        } else if (this.navigableMap != null) {
            dbKey = this.navigableMap.floorKey(dbKey);
        }
        return (T)(dbKey == null || dbKey instanceof DBNull ? null : dbKey.getValue());
    }

    public <T extends Comparable<T>> T floorKey(T key) {
        DBValue dbKey;
        DBValue dBValue = dbKey = key == null ? DBNull.getInstance() : new DBValue(key);
        if (!this.reverseScan) {
            if (this.nitriteMap != null) {
                dbKey = this.nitriteMap.floorKey(dbKey);
            } else if (this.navigableMap != null) {
                dbKey = this.navigableMap.floorKey(dbKey);
            }
        } else if (this.nitriteMap != null) {
            dbKey = this.nitriteMap.ceilingKey(dbKey);
        } else if (this.navigableMap != null) {
            dbKey = this.navigableMap.ceilingKey(dbKey);
        }
        return (T)(dbKey == null || dbKey instanceof DBNull ? null : dbKey.getValue());
    }

    public Object get(Comparable<?> comparable) {
        DBValue dbKey;
        DBValue dBValue = dbKey = comparable == null ? DBNull.getInstance() : new DBValue(comparable);
        if (this.nitriteMap != null) {
            return this.nitriteMap.get(dbKey);
        }
        if (this.navigableMap != null) {
            return this.navigableMap.get(dbKey);
        }
        return null;
    }

    public Iterable<? extends Pair<Comparable<?>, ?>> entries() {
        if (this.nitriteMap != null) {
            final Iterator entryIterator = !this.reverseScan ? this.nitriteMap.entries().iterator() : this.nitriteMap.reversedEntries().iterator();
            return () -> new Iterator<Pair<Comparable<?>, ?>>(){

                @Override
                public boolean hasNext() {
                    return entryIterator.hasNext();
                }

                @Override
                public Pair<Comparable<?>, ?> next() {
                    Pair next = (Pair)entryIterator.next();
                    DBValue dbKey = (DBValue)next.getFirst();
                    if (dbKey instanceof DBNull) {
                        return new Pair(null, next.getSecond());
                    }
                    return new Pair(dbKey.getValue(), next.getSecond());
                }
            };
        }
        if (this.navigableMap != null) {
            final Iterator entryIterator = this.reverseScan ? this.navigableMap.descendingMap().entrySet().iterator() : this.navigableMap.entrySet().iterator();
            return () -> new Iterator<Pair<Comparable<?>, ?>>(){

                @Override
                public boolean hasNext() {
                    return entryIterator.hasNext();
                }

                @Override
                public Pair<Comparable<?>, ?> next() {
                    Map.Entry next = (Map.Entry)entryIterator.next();
                    DBValue dbKey = (DBValue)next.getKey();
                    if (dbKey instanceof DBNull) {
                        return new Pair(null, next.getValue());
                    }
                    return new Pair(dbKey.getValue(), next.getValue());
                }
            };
        }
        return Collections.EMPTY_SET;
    }

    public List<NitriteId> getTerminalNitriteIds() {
        CopyOnWriteArrayList<NitriteId> terminalResult = new CopyOnWriteArrayList<NitriteId>();
        for (Pair<Comparable<?>, ?> entry : this.entries()) {
            if (entry.getSecond() instanceof List) {
                List nitriteIds = (List)entry.getSecond();
                terminalResult.addAll(nitriteIds);
            }
            if (!(entry.getSecond() instanceof NavigableMap)) continue;
            NavigableMap subMap = (NavigableMap)entry.getSecond();
            IndexMap indexMap = new IndexMap(subMap);
            List<NitriteId> nitriteIds = indexMap.getTerminalNitriteIds();
            terminalResult.addAll(nitriteIds);
        }
        return terminalResult;
    }

    @Generated
    public boolean isReverseScan() {
        return this.reverseScan;
    }

    @Generated
    public void setReverseScan(boolean reverseScan) {
        this.reverseScan = reverseScan;
    }
}

