/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.index;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import org.dizitart.no2.collection.FindPlan;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.FieldValues;
import org.dizitart.no2.common.Fields;
import org.dizitart.no2.common.util.IndexUtils;
import org.dizitart.no2.common.util.ObjectUtils;
import org.dizitart.no2.common.util.ValidationUtils;
import org.dizitart.no2.exceptions.FilterException;
import org.dizitart.no2.exceptions.IndexingException;
import org.dizitart.no2.filters.ComparableFilter;
import org.dizitart.no2.filters.TextFilter;
import org.dizitart.no2.index.IndexDescriptor;
import org.dizitart.no2.index.NitriteIndex;
import org.dizitart.no2.index.fulltext.TextTokenizer;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.store.NitriteStore;

public class TextIndex
implements NitriteIndex {
    private final IndexDescriptor indexDescriptor;
    private final NitriteStore<?> nitriteStore;
    private final TextTokenizer textTokenizer;

    public TextIndex(TextTokenizer textTokenizer, IndexDescriptor indexDescriptor, NitriteStore<?> nitriteStore) {
        this.textTokenizer = textTokenizer;
        this.indexDescriptor = indexDescriptor;
        this.nitriteStore = nitriteStore;
    }

    @Override
    public void write(FieldValues fieldValues) {
        Fields fields = fieldValues.getFields();
        List<String> fieldNames = fields.getFieldNames();
        String firstField = fieldNames.get(0);
        Object element = fieldValues.get(firstField);
        NitriteMap<String, List<?>> indexMap = this.findIndexMap();
        if (element == null) {
            this.addIndexElement(indexMap, fieldValues, null);
        } else if (element instanceof String) {
            this.addIndexElement(indexMap, fieldValues, (String)element);
        } else if (element.getClass().isArray()) {
            Object[] array;
            ValidationUtils.validateStringArrayIndexField(element, firstField);
            for (Object item : array = ObjectUtils.convertToObjectArray(element)) {
                this.addIndexElement(indexMap, fieldValues, (String)item);
            }
        } else if (element instanceof Iterable) {
            ValidationUtils.validateStringIterableIndexField((Iterable)element, firstField);
            Iterable iterable = (Iterable)element;
            for (Object item : iterable) {
                this.addIndexElement(indexMap, fieldValues, (String)item);
            }
        } else {
            throw new IndexingException("Index field " + firstField + " must be a String, String[] or Iterable<String>");
        }
    }

    @Override
    public void remove(FieldValues fieldValues) {
        Fields fields = fieldValues.getFields();
        List<String> fieldNames = fields.getFieldNames();
        String firstField = fieldNames.get(0);
        Object element = fieldValues.get(firstField);
        NitriteMap<String, List<?>> indexMap = this.findIndexMap();
        if (element == null) {
            this.removeIndexElement(indexMap, fieldValues, null);
        } else if (element instanceof String) {
            this.removeIndexElement(indexMap, fieldValues, (String)element);
        } else if (element.getClass().isArray()) {
            Object[] array;
            ValidationUtils.validateStringArrayIndexField(element, firstField);
            for (Object item : array = ObjectUtils.convertToObjectArray(element)) {
                this.removeIndexElement(indexMap, fieldValues, (String)item);
            }
        } else if (element instanceof Iterable) {
            ValidationUtils.validateStringIterableIndexField((Iterable)element, firstField);
            Iterable iterable = (Iterable)element;
            for (Object item : iterable) {
                this.removeIndexElement(indexMap, fieldValues, (String)item);
            }
        } else {
            throw new IndexingException("Index field " + firstField + " must be a String, String[] or Iterable<String>");
        }
    }

    @Override
    public void drop() {
        NitriteMap<String, List<?>> indexMap = this.findIndexMap();
        indexMap.clear();
        indexMap.drop();
    }

    @Override
    public LinkedHashSet<NitriteId> findNitriteIds(FindPlan findPlan) {
        if (findPlan.getIndexScanFilter() == null) {
            return new LinkedHashSet<NitriteId>();
        }
        NitriteMap<String, List<?>> indexMap = this.findIndexMap();
        List<ComparableFilter> filters = findPlan.getIndexScanFilter().getFilters();
        if (filters.size() == 1 && filters.get(0) instanceof TextFilter) {
            TextFilter textFilter = (TextFilter)filters.get(0);
            textFilter.setTextTokenizer(this.textTokenizer);
            return textFilter.applyOnTextIndex(indexMap);
        }
        throw new FilterException("Text index only supports a single TextFilter");
    }

    private NitriteMap<String, List<?>> findIndexMap() {
        String mapName = IndexUtils.deriveIndexMapName(this.indexDescriptor);
        return this.nitriteStore.openMap(mapName, String.class, CopyOnWriteArrayList.class);
    }

    private void addIndexElement(NitriteMap<String, List<?>> indexMap, FieldValues fieldValues, String value) {
        Set<String> words = this.decompose(value);
        for (String word : words) {
            List<NitriteId> nitriteIds = indexMap.get(word);
            if (nitriteIds == null) {
                nitriteIds = new CopyOnWriteArrayList();
            }
            nitriteIds = this.addNitriteIds(nitriteIds, fieldValues);
            indexMap.put(word, nitriteIds);
        }
    }

    private void removeIndexElement(NitriteMap<String, List<?>> indexMap, FieldValues fieldValues, String value) {
        Set<String> words = this.decompose(value);
        for (String word : words) {
            List<?> nitriteIds = indexMap.get(word);
            if (nitriteIds == null || nitriteIds.isEmpty()) continue;
            nitriteIds.remove(fieldValues.getNitriteId());
            if (nitriteIds.isEmpty()) {
                indexMap.remove(word);
                continue;
            }
            indexMap.put(word, nitriteIds);
        }
    }

    private Set<String> decompose(String fieldValue) {
        if (fieldValue == null) {
            return new HashSet<String>();
        }
        return this.textTokenizer.tokenize(fieldValue);
    }

    @Override
    @Generated
    public IndexDescriptor getIndexDescriptor() {
        return this.indexDescriptor;
    }
}

