/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.migration;

import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.common.tuples.Triplet;
import org.dizitart.no2.common.util.ObjectUtils;
import org.dizitart.no2.common.util.SecureString;
import org.dizitart.no2.migration.CustomInstruction;
import org.dizitart.no2.migration.Instruction;
import org.dizitart.no2.migration.InstructionType;
import org.dizitart.no2.migration.MigrationStep;
import org.dizitart.no2.repository.EntityDecorator;

public interface DatabaseInstruction
extends Instruction {
    default public DatabaseInstruction addUser(String username, String password) {
        MigrationStep migrationStep = new MigrationStep();
        migrationStep.setInstructionType(InstructionType.AddUser);
        migrationStep.setArguments(new Pair<String, SecureString>(username, new SecureString(password)));
        this.addStep(migrationStep);
        return this;
    }

    default public DatabaseInstruction changePassword(String username, String oldPassword, String newPassword) {
        MigrationStep migrationStep = new MigrationStep();
        migrationStep.setInstructionType(InstructionType.ChangePassword);
        migrationStep.setArguments(new Triplet<String, SecureString, SecureString>(username, new SecureString(oldPassword), new SecureString(newPassword)));
        this.addStep(migrationStep);
        return this;
    }

    default public DatabaseInstruction dropCollection(String collectionName) {
        MigrationStep migrationStep = new MigrationStep();
        migrationStep.setInstructionType(InstructionType.DropCollection);
        migrationStep.setArguments(collectionName);
        this.addStep(migrationStep);
        return this;
    }

    default public DatabaseInstruction dropRepository(Class<?> type) {
        return this.dropRepository(type, null);
    }

    default public DatabaseInstruction dropRepository(Class<?> type, String key) {
        return this.dropRepository(ObjectUtils.getEntityName(type), key);
    }

    default public DatabaseInstruction dropRepository(EntityDecorator<?> entityDecorator) {
        return this.dropRepository(entityDecorator, null);
    }

    default public DatabaseInstruction dropRepository(EntityDecorator<?> entityDecorator, String key) {
        return this.dropRepository(entityDecorator.getEntityName(), key);
    }

    default public DatabaseInstruction dropRepository(String typeName) {
        return this.dropRepository(typeName, null);
    }

    default public DatabaseInstruction dropRepository(String typeName, String key) {
        MigrationStep migrationStep = new MigrationStep();
        migrationStep.setInstructionType(InstructionType.DropRepository);
        migrationStep.setArguments(new Pair<String, String>(typeName, key));
        this.addStep(migrationStep);
        return this;
    }

    default public DatabaseInstruction customInstruction(CustomInstruction instruction) {
        MigrationStep migrationStep = new MigrationStep();
        migrationStep.setInstructionType(InstructionType.Custom);
        migrationStep.setArguments(instruction);
        this.addStep(migrationStep);
        return this;
    }
}

