/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.store;

import org.dizitart.no2.common.RecordStream;
import org.dizitart.no2.common.meta.Attributes;
import org.dizitart.no2.common.meta.AttributesAware;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.common.util.StringUtils;
import org.dizitart.no2.store.NitriteStore;

public interface NitriteMap<Key, Value>
extends AttributesAware,
AutoCloseable {
    public boolean containsKey(Key var1);

    public Value get(Key var1);

    public void clear();

    public boolean isClosed();

    @Override
    public void close();

    public Iterable<Value> values();

    public Iterable<Key> keys();

    public Value remove(Key var1);

    public void put(Key var1, Value var2);

    public long size();

    public Value putIfAbsent(Key var1, Value var2);

    public Key higherKey(Key var1);

    public Key ceilingKey(Key var1);

    public Key lowerKey(Key var1);

    public Key floorKey(Key var1);

    public boolean isEmpty();

    public NitriteStore<?> getStore();

    public String getName();

    public RecordStream<Pair<Key, Value>> entries();

    public RecordStream<Pair<Key, Value>> reversedEntries();

    public void drop();

    public boolean isDropped();

    @Override
    default public Attributes getAttributes() {
        NitriteMap metaMap;
        if (!this.isDropped() && (metaMap = this.getStore().openMap("$nitrite_meta_map", String.class, Attributes.class)) != null && !this.getName().contentEquals("$nitrite_meta_map")) {
            return (Attributes)metaMap.get(this.getName());
        }
        return null;
    }

    @Override
    default public void setAttributes(Attributes attributes) {
        NitriteMap<String, Attributes> metaMap;
        if (!this.isDropped() && (metaMap = this.getStore().openMap("$nitrite_meta_map", String.class, Attributes.class)) != null && !this.getName().contentEquals("$nitrite_meta_map")) {
            metaMap.put(this.getName(), attributes);
        }
    }

    default public void updateLastModifiedTime() {
        if (!this.isDropped()) {
            if (StringUtils.isNullOrEmpty(this.getName()) || "$nitrite_meta_map".equals(this.getName())) {
                return;
            }
            NitriteMap<String, Attributes> metaMap = this.getStore().openMap("$nitrite_meta_map", String.class, Attributes.class);
            if (metaMap != null) {
                Attributes attributes = (Attributes)metaMap.get(this.getName());
                if (attributes == null) {
                    attributes = new Attributes(this.getName());
                    metaMap.put(this.getName(), attributes);
                }
                attributes.set("last_modified_at", Long.toString(System.currentTimeMillis()));
            }
        }
    }
}

