/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.store;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.common.util.ObjectUtils;
import org.dizitart.no2.store.MapMetaData;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.store.NitriteStore;

public class StoreCatalog {
    private final NitriteMap<String, Document> catalogMap;

    public StoreCatalog(NitriteStore<?> nitriteStore) {
        this.catalogMap = nitriteStore.openMap("$nitrite_catalog", String.class, Document.class);
    }

    public void writeCollectionEntry(String name) {
        Document document = this.catalogMap.get("collections");
        if (document == null) {
            document = Document.createDocument();
        }
        MapMetaData metaData = new MapMetaData(document);
        metaData.getMapNames().add(name);
        this.catalogMap.put("collections", metaData.getInfo());
    }

    public void writeRepositoryEntry(String name) {
        Document document = this.catalogMap.get("repositories");
        if (document == null) {
            document = Document.createDocument();
        }
        MapMetaData metaData = new MapMetaData(document);
        metaData.getMapNames().add(name);
        this.catalogMap.put("repositories", metaData.getInfo());
    }

    public void writeKeyedRepositoryEntry(String name) {
        Document document = this.catalogMap.get("keyed-repositories");
        if (document == null) {
            document = Document.createDocument();
        }
        MapMetaData metaData = new MapMetaData(document);
        metaData.getMapNames().add(name);
        this.catalogMap.put("keyed-repositories", metaData.getInfo());
    }

    public Set<String> getCollectionNames() {
        Document document = this.catalogMap.get("collections");
        if (document == null) {
            return new HashSet<String>();
        }
        MapMetaData metaData = new MapMetaData(document);
        return metaData.getMapNames();
    }

    public Set<String> getRepositoryNames() {
        Document document = this.catalogMap.get("repositories");
        if (document == null) {
            return new HashSet<String>();
        }
        MapMetaData metaData = new MapMetaData(document);
        return metaData.getMapNames();
    }

    public Map<String, Set<String>> getKeyedRepositoryNames() {
        Document document = this.catalogMap.get("keyed-repositories");
        if (document == null) {
            return new HashMap<String, Set<String>>();
        }
        MapMetaData metaData = new MapMetaData(document);
        Set<String> keyedRepositoryNames = metaData.getMapNames();
        HashMap<String, Set<String>> resultMap = new HashMap<String, Set<String>>();
        for (String field : keyedRepositoryNames) {
            String key = ObjectUtils.getKeyName(field);
            String type = ObjectUtils.getKeyedRepositoryType(field);
            Set types = resultMap.containsKey(key) ? (Set)resultMap.get(key) : new HashSet();
            types.add(type);
            resultMap.put(key, types);
        }
        return resultMap;
    }

    public void remove(String name) {
        for (Pair pair : this.catalogMap.entries()) {
            String catalogue = (String)pair.getFirst();
            Document document = (Document)pair.getSecond();
            MapMetaData metaData = new MapMetaData(document);
            if (!metaData.getMapNames().contains(name)) continue;
            metaData.getMapNames().remove(name);
            this.catalogMap.put(catalogue, metaData.getInfo());
            break;
        }
    }
}

