/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2;

import java.util.Map;
import java.util.Set;
import org.dizitart.no2.NitriteBuilder;
import org.dizitart.no2.NitriteConfig;
import org.dizitart.no2.collection.NitriteCollection;
import org.dizitart.no2.common.Constants;
import org.dizitart.no2.common.util.ObjectUtils;
import org.dizitart.no2.common.util.ValidationUtils;
import org.dizitart.no2.exceptions.NitriteIOException;
import org.dizitart.no2.exceptions.ValidationException;
import org.dizitart.no2.repository.EntityDecorator;
import org.dizitart.no2.repository.ObjectRepository;
import org.dizitart.no2.store.NitriteStore;
import org.dizitart.no2.store.StoreMetaData;
import org.dizitart.no2.transaction.Session;

public interface Nitrite
extends AutoCloseable {
    public static NitriteBuilder builder() {
        return new NitriteBuilder();
    }

    public void commit();

    public NitriteCollection getCollection(String var1);

    public <T> ObjectRepository<T> getRepository(Class<T> var1);

    public <T> ObjectRepository<T> getRepository(Class<T> var1, String var2);

    public <T> ObjectRepository<T> getRepository(EntityDecorator<T> var1);

    public <T> ObjectRepository<T> getRepository(EntityDecorator<T> var1, String var2);

    public void destroyCollection(String var1);

    public <T> void destroyRepository(Class<T> var1);

    public <T> void destroyRepository(Class<T> var1, String var2);

    public <T> void destroyRepository(EntityDecorator<T> var1);

    public <T> void destroyRepository(EntityDecorator<T> var1, String var2);

    public Set<String> listCollectionNames();

    public Set<String> listRepositories();

    public Map<String, Set<String>> listKeyedRepositories();

    public boolean hasUnsavedChanges();

    public boolean isClosed();

    public NitriteConfig getConfig();

    public NitriteStore<?> getStore();

    public StoreMetaData getDatabaseMetaData();

    public Session createSession();

    @Override
    public void close();

    default public boolean hasCollection(String name) {
        this.checkOpened();
        return this.listCollectionNames().contains(name);
    }

    default public <T> boolean hasRepository(Class<T> type) {
        this.checkOpened();
        String name = ObjectUtils.findRepositoryName(type, null);
        return this.listRepositories().contains(name);
    }

    default public <T> boolean hasRepository(Class<T> type, String key) {
        this.checkOpened();
        String entityName = ObjectUtils.getEntityName(type);
        return this.listKeyedRepositories().containsKey(key) && this.listKeyedRepositories().get(key).contains(entityName);
    }

    default public <T> boolean hasRepository(EntityDecorator<T> entityDecorator) {
        this.checkOpened();
        String name = ObjectUtils.findRepositoryNameByDecorator(entityDecorator, null);
        return this.listRepositories().contains(name);
    }

    default public <T> boolean hasRepository(EntityDecorator<T> entityDecorator, String key) {
        this.checkOpened();
        return this.listKeyedRepositories().containsKey(key) && this.listKeyedRepositories().get(key).contains(entityDecorator.getEntityName());
    }

    default public void validateCollectionName(String name) {
        ValidationUtils.notNull(name, "name cannot be null");
        ValidationUtils.notEmpty(name, "name cannot be empty");
        for (String reservedName : Constants.RESERVED_NAMES) {
            if (!name.contains(reservedName)) continue;
            throw new ValidationException("Name cannot contain " + reservedName);
        }
    }

    default public void checkOpened() {
        if (this.getStore() == null || this.getStore().isClosed()) {
            throw new NitriteIOException("Store is closed");
        }
    }
}

