/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.collection;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.dizitart.no2.collection.NitriteDocument;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.tuples.Pair;

public interface Document
extends Iterable<Pair<String, Object>>,
Cloneable,
Serializable {
    public static Document createDocument() {
        return new NitriteDocument();
    }

    public static Document createDocument(String key, Object value) {
        LinkedHashMap<String, Object> document = new LinkedHashMap<String, Object>();
        document.put(key, value);
        return new NitriteDocument((Map<String, Object>)document);
    }

    public static Document createDocument(Map<String, Object> documentMap) {
        LinkedHashMap<String, Object> document = new LinkedHashMap<String, Object>(documentMap);
        return new NitriteDocument((Map<String, Object>)document);
    }

    public Document put(String var1, Object var2);

    public Object get(String var1);

    public <T> T get(String var1, Class<T> var2);

    public NitriteId getId();

    public Set<String> getFields();

    public boolean hasId();

    public void remove(String var1);

    public Document clone();

    public int size();

    public Document merge(Document var1);

    public boolean containsKey(String var1);

    public boolean containsField(String var1);

    default public Integer getRevision() {
        if (!this.containsKey("_revision")) {
            return 0;
        }
        return this.get("_revision", Integer.class);
    }

    default public String getSource() {
        if (!this.containsKey("_source")) {
            return "";
        }
        return this.get("_source", String.class);
    }

    default public Long getLastModifiedSinceEpoch() {
        if (!this.containsKey("_modified")) {
            return 0L;
        }
        return this.get("_modified", Long.class);
    }
}

