/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.common;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.dizitart.no2.common.util.StringUtils;
import org.dizitart.no2.common.util.ValidationUtils;

public class Fields
implements Comparable<Fields>,
Serializable {
    private static final long serialVersionUID = 1601646404L;
    protected List<String> fieldNames = new ArrayList<String>();

    public static Fields withNames(String ... fields) {
        ValidationUtils.notNull(fields, "fields cannot be null");
        ValidationUtils.notEmpty(fields, "fields cannot be empty");
        Fields f = new Fields();
        f.fieldNames.addAll(Arrays.asList(fields));
        return f;
    }

    public Fields addField(String field) {
        ValidationUtils.notNull(field, "field cannot be null");
        ValidationUtils.notEmpty(field, "field cannot be empty");
        this.fieldNames.add(field);
        return this;
    }

    public List<String> getFieldNames() {
        return Collections.unmodifiableList(this.fieldNames);
    }

    public boolean startsWith(Fields other) {
        ValidationUtils.notNull(other, "other cannot be null");
        int length = Math.min(this.fieldNames.size(), other.fieldNames.size());
        if (other.fieldNames.size() > length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            String otherField;
            String thisField = this.fieldNames.get(i);
            if (thisField.equals(otherField = other.fieldNames.get(i))) continue;
            return false;
        }
        return true;
    }

    public String getEncodedName() {
        return StringUtils.join("|", this.getFieldNames());
    }

    public String toString() {
        return this.fieldNames.toString();
    }

    @Override
    public int compareTo(Fields other) {
        int otherFieldsSize;
        if (other == null) {
            return 1;
        }
        int fieldsSize = this.getFieldNames().size();
        int result = Integer.compare(fieldsSize, otherFieldsSize = other.getFieldNames().size());
        if (result == 0) {
            String[] keys = this.getFieldNames().toArray(new String[0]);
            String[] otherKeys = other.getFieldNames().toArray(new String[0]);
            for (int i = 0; i < keys.length; ++i) {
                int cmp = keys[i].compareTo(otherKeys[i]);
                if (cmp == 0) continue;
                return cmp;
            }
        }
        return result;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.fieldNames);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.fieldNames = (List)stream.readObject();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Fields)) {
            return false;
        }
        Fields other = (Fields)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$fieldNames = this.getFieldNames();
        List<String> other$fieldNames = other.getFieldNames();
        return !(this$fieldNames == null ? other$fieldNames != null : !((Object)this$fieldNames).equals(other$fieldNames));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Fields;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $fieldNames = this.getFieldNames();
        result = result * 59 + ($fieldNames == null ? 43 : ((Object)$fieldNames).hashCode());
        return result;
    }

    @Generated
    void setFieldNames(List<String> fieldNames) {
        this.fieldNames = fieldNames;
    }
}

