/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.common.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class Iterables {
    private Iterables() {
    }

    public static <T> T firstOrNull(Iterable<T> iterable) {
        if (iterable == null) {
            return null;
        }
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static <T> List<T> toList(Iterable<T> iterable) {
        if (iterable instanceof List) {
            return (List)iterable;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T item : iterable) {
            list.add(item);
        }
        return list;
    }

    public static <T> Set<T> toSet(Iterable<T> iterable) {
        if (iterable instanceof Set) {
            return (Set)iterable;
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        for (T item : iterable) {
            set.add(item);
        }
        return set;
    }

    public static <T> T[] toArray(Iterable<T> iterable, Class<T> type) {
        Object[] dummy = (Object[])Array.newInstance(type, 0);
        if (iterable instanceof Collection) {
            return ((Collection)iterable).toArray(dummy);
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T item : iterable) {
            list.add(item);
        }
        return list.toArray(dummy);
    }

    public static <T> boolean arrayContains(T[] array, T element) {
        for (T item : array) {
            if (!item.equals(element)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static <T> List<T> listOf(T ... items) {
        if (items != null) {
            return Arrays.asList(items);
        }
        return Collections.emptyList();
    }

    @SafeVarargs
    public static <T> Set<T> setOf(T ... items) {
        HashSet<T> set = new HashSet<T>();
        if (items != null) {
            set.addAll(Arrays.asList(items));
        }
        return set;
    }

    public static long size(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        long count = 0L;
        for (Object ignored : iterable) {
            ++count;
        }
        return count;
    }

    static Object[] toArray(Iterable iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).toArray();
        }
        ArrayList list = new ArrayList();
        for (Object item : iterable) {
            list.add(item);
        }
        return list.toArray();
    }
}

