/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.filters;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.common.util.Numbers;
import org.dizitart.no2.common.util.ObjectUtils;
import org.dizitart.no2.exceptions.FilterException;
import org.dizitart.no2.filters.AndFilter;
import org.dizitart.no2.filters.EqualsFilter;
import org.dizitart.no2.filters.Filter;
import org.dizitart.no2.filters.GreaterEqualFilter;
import org.dizitart.no2.filters.GreaterThanFilter;
import org.dizitart.no2.filters.InFilter;
import org.dizitart.no2.filters.LesserEqualFilter;
import org.dizitart.no2.filters.LesserThanFilter;
import org.dizitart.no2.filters.NitriteFilter;
import org.dizitart.no2.filters.NotFilter;
import org.dizitart.no2.filters.NotInFilter;
import org.dizitart.no2.filters.OrFilter;
import org.dizitart.no2.filters.RegexFilter;
import org.dizitart.no2.filters.TextFilter;

class ElementMatchFilter
extends NitriteFilter {
    private final String field;
    private final Filter elementFilter;

    ElementMatchFilter(String field, Filter elementFilter) {
        this.elementFilter = elementFilter;
        this.field = field;
    }

    @Override
    public boolean apply(Pair<NitriteId, Document> element) {
        if (this.elementFilter instanceof ElementMatchFilter) {
            throw new FilterException("Nested elemMatch filter is not supported");
        }
        if (this.elementFilter instanceof TextFilter) {
            throw new FilterException("Text filter is not supported in elemMatch filter");
        }
        Document document = element.getSecond();
        Object fieldValue = document.get(this.field);
        if (fieldValue == null) {
            return false;
        }
        if (fieldValue.getClass().isArray()) {
            int length = Array.getLength(fieldValue);
            ArrayList<Object> list = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                Object item = Array.get(fieldValue, i);
                list.add(item);
            }
            return this.matches(list, this.elementFilter);
        }
        if (fieldValue instanceof Iterable) {
            return this.matches((Iterable)fieldValue, this.elementFilter);
        }
        throw new FilterException("elemMatch filter only applies to array or iterable");
    }

    public String toString() {
        return "elemMatch(" + this.field + " : " + this.elementFilter.toString() + ")";
    }

    private boolean matches(Iterable iterable, Filter filter) {
        for (Object item : iterable) {
            if (!this.matchElement(item, filter)) continue;
            return true;
        }
        return false;
    }

    private boolean matchElement(Object item, Filter filter) {
        if (filter instanceof AndFilter) {
            List<Filter> filters = ((AndFilter)filter).getFilters();
            for (Filter f : filters) {
                if (this.matchElement(item, f)) continue;
                return false;
            }
            return true;
        }
        if (filter instanceof OrFilter) {
            List<Filter> filters = ((OrFilter)filter).getFilters();
            for (Filter f : filters) {
                if (!this.matchElement(item, f)) continue;
                return true;
            }
            return false;
        }
        if (filter instanceof NotFilter) {
            Filter not = ((NotFilter)filter).getFilter();
            return !this.matchElement(item, not);
        }
        if (filter instanceof EqualsFilter) {
            return this.matchEqual(item, filter);
        }
        if (filter instanceof GreaterEqualFilter) {
            return this.matchGreaterEqual(item, filter);
        }
        if (filter instanceof GreaterThanFilter) {
            return this.matchGreater(item, filter);
        }
        if (filter instanceof LesserEqualFilter) {
            return this.matchLesserEqual(item, filter);
        }
        if (filter instanceof LesserThanFilter) {
            return this.matchLesser(item, filter);
        }
        if (filter instanceof InFilter) {
            return this.matchIn(item, filter);
        }
        if (filter instanceof NotInFilter) {
            return this.matchNotIn(item, filter);
        }
        if (filter instanceof RegexFilter) {
            return this.matchRegex(item, filter);
        }
        throw new FilterException("Filter " + filter.getClass().getSimpleName() + " is not a supported in elemMatch");
    }

    private boolean matchEqual(Object item, Filter filter) {
        Object value = ((EqualsFilter)filter).getValue();
        if (item instanceof Document) {
            Document document = (Document)item;
            Object docValue = document.get(((EqualsFilter)filter).getField());
            return ObjectUtils.deepEquals(value, docValue);
        }
        return ObjectUtils.deepEquals(item, value);
    }

    private boolean matchGreater(Object item, Filter filter) {
        Comparable comparable = ((GreaterThanFilter)filter).getComparable();
        if (item instanceof Number && comparable instanceof Number) {
            return Numbers.compare((Number)item, (Number)((Object)comparable)) > 0;
        }
        if (item instanceof Comparable) {
            Comparable arg = (Comparable)item;
            return arg.compareTo(comparable) > 0;
        }
        if (item instanceof Document) {
            Document document = (Document)item;
            Object docValue = document.get(((GreaterThanFilter)filter).getField());
            if (docValue instanceof Comparable) {
                Comparable arg = (Comparable)docValue;
                return arg.compareTo(comparable) > 0;
            }
            throw new FilterException(((GreaterThanFilter)filter).getField() + " is not comparable");
        }
        throw new FilterException(item + " is not comparable");
    }

    private boolean matchGreaterEqual(Object item, Filter filter) {
        Comparable comparable = ((GreaterEqualFilter)filter).getComparable();
        if (item instanceof Number && comparable instanceof Number) {
            return Numbers.compare((Number)item, (Number)((Object)comparable)) >= 0;
        }
        if (item instanceof Comparable) {
            Comparable arg = (Comparable)item;
            return arg.compareTo(comparable) >= 0;
        }
        if (item instanceof Document) {
            Document document = (Document)item;
            Object docValue = document.get(((GreaterEqualFilter)filter).getField());
            if (docValue instanceof Comparable) {
                Comparable arg = (Comparable)docValue;
                return arg.compareTo(comparable) >= 0;
            }
            throw new FilterException(((GreaterEqualFilter)filter).getField() + " is not comparable");
        }
        throw new FilterException(item + " is not comparable");
    }

    private boolean matchLesserEqual(Object item, Filter filter) {
        Comparable comparable = ((LesserEqualFilter)filter).getComparable();
        if (item instanceof Number && comparable instanceof Number) {
            return Numbers.compare((Number)item, (Number)((Object)comparable)) <= 0;
        }
        if (item instanceof Comparable) {
            Comparable arg = (Comparable)item;
            return arg.compareTo(comparable) <= 0;
        }
        if (item instanceof Document) {
            Document document = (Document)item;
            Object docValue = document.get(((LesserEqualFilter)filter).getField());
            if (docValue instanceof Comparable) {
                Comparable arg = (Comparable)docValue;
                return arg.compareTo(comparable) <= 0;
            }
            throw new FilterException(((LesserEqualFilter)filter).getField() + " is not comparable");
        }
        throw new FilterException(item + " is not comparable");
    }

    private boolean matchLesser(Object item, Filter filter) {
        Comparable comparable = ((LesserThanFilter)filter).getComparable();
        if (item instanceof Number && comparable instanceof Number) {
            return Numbers.compare((Number)item, (Number)((Object)comparable)) < 0;
        }
        if (item instanceof Comparable) {
            Comparable arg = (Comparable)item;
            return arg.compareTo(comparable) < 0;
        }
        if (item instanceof Document) {
            Document document = (Document)item;
            Object docValue = document.get(((LesserThanFilter)filter).getField());
            if (docValue instanceof Comparable) {
                Comparable arg = (Comparable)docValue;
                return arg.compareTo(comparable) < 0;
            }
            throw new FilterException(((LesserThanFilter)filter).getField() + " is not comparable");
        }
        throw new FilterException(item + " is not comparable");
    }

    private boolean matchIn(Object item, Filter filter) {
        Set<Comparable<?>> values = ((InFilter)filter).getComparableSet();
        if (values != null) {
            if (item instanceof Document) {
                Document document = (Document)item;
                Object docValue = document.get(((InFilter)filter).getField());
                if (docValue instanceof Comparable) {
                    return values.contains(docValue);
                }
            } else if (item instanceof Comparable) {
                return values.contains(item);
            }
        }
        return false;
    }

    private boolean matchNotIn(Object item, Filter filter) {
        Set<Comparable<?>> values = ((NotInFilter)filter).getComparableSet();
        if (values != null) {
            if (item instanceof Document) {
                Document document = (Document)item;
                Object docValue = document.get(((NotInFilter)filter).getField());
                if (docValue instanceof Comparable) {
                    return !values.contains(docValue);
                }
            } else if (item instanceof Comparable) {
                return !values.contains(item);
            }
        }
        return false;
    }

    private boolean matchRegex(Object item, Filter filter) {
        String value = (String)((RegexFilter)filter).getValue();
        if (item instanceof String) {
            Pattern pattern = Pattern.compile(value);
            Matcher matcher = pattern.matcher((String)item);
            return matcher.find();
        }
        if (item instanceof Document) {
            Document document = (Document)item;
            Object docValue = document.get(((RegexFilter)filter).getField());
            if (docValue instanceof String) {
                Pattern pattern = Pattern.compile(value);
                Matcher matcher = pattern.matcher((String)docValue);
                return matcher.find();
            }
            throw new FilterException(((RegexFilter)filter).getField() + " is not a string");
        }
        throw new FilterException(item + " is not a string");
    }
}

