/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.transaction;

import java.util.Collection;
import org.dizitart.no2.NitriteConfig;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.FindOptions;
import org.dizitart.no2.collection.NitriteCollection;
import org.dizitart.no2.collection.UpdateOptions;
import org.dizitart.no2.collection.events.CollectionEventListener;
import org.dizitart.no2.common.WriteResult;
import org.dizitart.no2.common.meta.Attributes;
import org.dizitart.no2.common.processors.Processor;
import org.dizitart.no2.common.util.ValidationUtils;
import org.dizitart.no2.filters.Filter;
import org.dizitart.no2.index.IndexDescriptor;
import org.dizitart.no2.index.IndexOptions;
import org.dizitart.no2.repository.Cursor;
import org.dizitart.no2.repository.EntityDecorator;
import org.dizitart.no2.repository.ObjectRepository;
import org.dizitart.no2.repository.RepositoryOperations;
import org.dizitart.no2.store.NitriteStore;
import org.dizitart.no2.transaction.TransactionConfig;

class DefaultTransactionalRepository<T>
implements ObjectRepository<T> {
    private final ObjectRepository<T> primary;
    private final NitriteCollection backingCollection;
    private final NitriteConfig nitriteConfig;
    private RepositoryOperations operations;
    private Class<T> type;
    private EntityDecorator<T> entityDecorator;

    public DefaultTransactionalRepository(Class<T> type, ObjectRepository<T> primary, NitriteCollection backingCollection, NitriteConfig nitriteConfig) {
        this.type = type;
        this.primary = primary;
        this.backingCollection = backingCollection;
        this.nitriteConfig = nitriteConfig;
        this.initialize();
    }

    public DefaultTransactionalRepository(EntityDecorator<T> entityDecorator, ObjectRepository<T> primary, NitriteCollection backingCollection, TransactionConfig nitriteConfig) {
        this.entityDecorator = entityDecorator;
        this.primary = primary;
        this.backingCollection = backingCollection;
        this.nitriteConfig = nitriteConfig;
        this.initialize();
    }

    @Override
    public void addProcessor(Processor processor) {
        this.backingCollection.addProcessor(processor);
    }

    @Override
    public void createIndex(IndexOptions indexOptions, String ... fieldNames) {
        this.backingCollection.createIndex(indexOptions, fieldNames);
    }

    @Override
    public void rebuildIndex(String ... fieldNames) {
        this.backingCollection.rebuildIndex(fieldNames);
    }

    @Override
    public Collection<IndexDescriptor> listIndices() {
        return this.backingCollection.listIndices();
    }

    @Override
    public boolean hasIndex(String ... fieldNames) {
        return this.backingCollection.hasIndex(fieldNames);
    }

    @Override
    public boolean isIndexing(String ... fieldNames) {
        return this.backingCollection.isIndexing(fieldNames);
    }

    @Override
    public void dropIndex(String ... fieldNames) {
        this.backingCollection.dropIndex(fieldNames);
    }

    @Override
    public void dropAllIndices() {
        this.backingCollection.dropAllIndices();
    }

    @Override
    public WriteResult insert(T[] elements) {
        ValidationUtils.notNull(elements, "a null object cannot be inserted");
        ValidationUtils.containsNull(elements, "a null object cannot be inserted");
        return this.backingCollection.insert(this.operations.toDocuments(elements));
    }

    @Override
    public WriteResult update(T element, boolean insertIfAbsent) {
        ValidationUtils.notNull(element, "a null object cannot be used for update");
        return this.update(this.operations.createUniqueFilter(element), element, UpdateOptions.updateOptions(insertIfAbsent, true));
    }

    @Override
    public WriteResult update(Filter filter, T update, UpdateOptions updateOptions) {
        ValidationUtils.notNull(update, "a null object cannot be used for update");
        Document updateDocument = this.operations.toDocument(update, true);
        if (updateOptions == null || !updateOptions.isInsertIfAbsent()) {
            this.operations.removeNitriteId(updateDocument);
        }
        return this.backingCollection.update(this.operations.asObjectFilter(filter), updateDocument, updateOptions);
    }

    @Override
    public WriteResult update(Filter filter, Document update, boolean justOnce) {
        ValidationUtils.notNull(update, "a null document cannot be used for update");
        this.operations.removeNitriteId(update);
        this.operations.serializeFields(update);
        return this.backingCollection.update(this.operations.asObjectFilter(filter), update, UpdateOptions.updateOptions(false, justOnce));
    }

    @Override
    public WriteResult remove(T element) {
        ValidationUtils.notNull(element, "a null object cannot be removed");
        return this.remove((T)this.operations.createUniqueFilter(element));
    }

    @Override
    public WriteResult remove(Filter filter, boolean justOne) {
        return this.backingCollection.remove(this.operations.asObjectFilter(filter), justOne);
    }

    @Override
    public void clear() {
        this.backingCollection.clear();
    }

    @Override
    public Cursor<T> find(Filter filter, FindOptions findOptions) {
        return this.operations.find(filter, findOptions, this.type);
    }

    @Override
    public <I> T getById(I id) {
        T item;
        T t = item = this.primary == null ? null : (T)this.primary.getById(id);
        if (item == null) {
            Filter idFilter = this.operations.createIdFilter(id);
            return this.find(idFilter).firstOrNull();
        }
        return item;
    }

    @Override
    public void drop() {
        this.backingCollection.drop();
    }

    @Override
    public boolean isDropped() {
        return this.backingCollection.isDropped();
    }

    @Override
    public boolean isOpen() {
        return this.backingCollection.isOpen();
    }

    @Override
    public void close() {
        this.backingCollection.close();
    }

    @Override
    public long size() {
        return this.backingCollection.size();
    }

    @Override
    public NitriteStore<?> getStore() {
        return this.backingCollection.getStore();
    }

    @Override
    public void subscribe(CollectionEventListener listener) {
        this.backingCollection.subscribe(listener);
    }

    @Override
    public void unsubscribe(CollectionEventListener listener) {
        this.backingCollection.unsubscribe(listener);
    }

    @Override
    public Attributes getAttributes() {
        return this.backingCollection.getAttributes();
    }

    @Override
    public void setAttributes(Attributes attributes) {
        this.backingCollection.setAttributes(attributes);
    }

    @Override
    public Class<T> getType() {
        if (this.entityDecorator != null) {
            return this.entityDecorator.getEntityType();
        }
        return this.type;
    }

    @Override
    public NitriteCollection getDocumentCollection() {
        return this.backingCollection;
    }

    private void initialize() {
        this.operations = this.entityDecorator != null ? new RepositoryOperations(this.entityDecorator, this.backingCollection, this.nitriteConfig) : new RepositoryOperations(this.type, this.backingCollection, this.nitriteConfig);
        this.operations.createIndices();
    }
}

