/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.transaction;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.dizitart.no2.common.RecordStream;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.common.util.ObjectUtils;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.store.NitriteStore;
import org.dizitart.no2.store.memory.InMemoryMap;

class TransactionalMap<K, V>
implements NitriteMap<K, V> {
    private final NitriteMap<K, V> primary;
    private final NitriteMap<K, V> backingMap;
    private final String mapName;
    private final NitriteStore<?> store;
    private final Set<K> tombstones;
    private final AtomicBoolean droppedFlag;
    private final AtomicBoolean closedFlag;
    private boolean cleared = false;

    public TransactionalMap(String mapName, NitriteMap<K, V> primary, NitriteStore<?> store) {
        this.mapName = mapName;
        this.primary = primary != null ? primary : new InMemoryMap(mapName, store);
        this.store = store;
        this.backingMap = new InMemoryMap<K, V>(mapName, store);
        this.tombstones = new HashSet<K>();
        this.closedFlag = new AtomicBoolean(false);
        this.droppedFlag = new AtomicBoolean(false);
    }

    @Override
    public boolean containsKey(K k) {
        if (this.cleared) {
            return false;
        }
        if (this.backingMap.containsKey(k)) {
            return true;
        }
        if (this.tombstones.contains(k)) {
            return false;
        }
        return this.primary.containsKey(k);
    }

    @Override
    public V get(K k) {
        if (this.tombstones.contains(k) || this.cleared) {
            return null;
        }
        Object result = this.backingMap.get(k);
        if (result == null && (result = this.primary.get(k)) instanceof CopyOnWriteArrayList) {
            List list = ObjectUtils.deepCopy((CopyOnWriteArrayList)result);
            this.backingMap.put(k, list);
            result = list;
        }
        return result;
    }

    @Override
    public NitriteStore<?> getStore() {
        return this.store;
    }

    @Override
    public void clear() {
        this.backingMap.clear();
        this.cleared = true;
        this.getStore().closeMap(this.mapName);
    }

    @Override
    public String getName() {
        return this.mapName;
    }

    @Override
    public RecordStream<V> values() {
        if (this.cleared) {
            return RecordStream.empty();
        }
        return RecordStream.fromIterable(() -> new Iterator<V>(){
            private final Iterator entryIterator;
            {
                this.entryIterator = TransactionalMap.this.entries().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.entryIterator.hasNext();
            }

            @Override
            public V next() {
                return ((Pair)this.entryIterator.next()).getSecond();
            }
        });
    }

    @Override
    public V remove(K k) {
        V item = null;
        if (this.cleared || this.tombstones.contains(k)) {
            return null;
        }
        if (this.backingMap.containsKey(k)) {
            item = this.backingMap.remove(k);
        } else if (this.primary.containsKey(k)) {
            item = this.primary.get(k);
        }
        this.tombstones.add(k);
        return item;
    }

    @Override
    public RecordStream<K> keys() {
        if (this.cleared) {
            return RecordStream.empty();
        }
        return RecordStream.fromCombined(RecordStream.except(this.primary.keys(), this.tombstones), this.backingMap.keys());
    }

    @Override
    public void put(K k, V v) {
        this.cleared = false;
        this.tombstones.remove(k);
        this.backingMap.put(k, v);
    }

    @Override
    public long size() {
        if (this.cleared) {
            return 0L;
        }
        return this.backingMap.size();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        this.cleared = false;
        V v = this.get(key);
        if (v == null) {
            this.put(key, value);
        }
        return v;
    }

    @Override
    public RecordStream<Pair<K, V>> entries() {
        return this.getStream(this.primary.entries(), this.backingMap.entries());
    }

    @Override
    public RecordStream<Pair<K, V>> reversedEntries() {
        return this.getStream(this.primary.reversedEntries(), this.backingMap.reversedEntries());
    }

    @Override
    public K higherKey(K k) {
        if (this.cleared) {
            return null;
        }
        K primaryKey = this.primary.higherKey(k);
        K backingKey = this.backingMap.higherKey(k);
        if (primaryKey == null) {
            return backingKey;
        }
        if (backingKey == null) {
            return primaryKey;
        }
        TreeSet<K> keySet = new TreeSet<K>();
        keySet.add(backingKey);
        keySet.add(primaryKey);
        return keySet.higher(k);
    }

    @Override
    public K ceilingKey(K k) {
        if (this.cleared) {
            return null;
        }
        K primaryKey = this.primary.ceilingKey(k);
        K backingKey = this.backingMap.ceilingKey(k);
        if (primaryKey == null) {
            return backingKey;
        }
        if (backingKey == null) {
            return primaryKey;
        }
        TreeSet<K> keySet = new TreeSet<K>();
        keySet.add(backingKey);
        keySet.add(primaryKey);
        return keySet.ceiling(k);
    }

    @Override
    public K lowerKey(K k) {
        if (this.cleared) {
            return null;
        }
        K primaryKey = this.primary.lowerKey(k);
        K backingKey = this.backingMap.lowerKey(k);
        if (primaryKey == null) {
            return backingKey;
        }
        if (backingKey == null) {
            return primaryKey;
        }
        TreeSet<K> keySet = new TreeSet<K>();
        keySet.add(backingKey);
        keySet.add(primaryKey);
        return keySet.lower(k);
    }

    @Override
    public K floorKey(K k) {
        if (this.cleared) {
            return null;
        }
        K primaryKey = this.primary.floorKey(k);
        K backingKey = this.backingMap.floorKey(k);
        if (primaryKey == null) {
            return backingKey;
        }
        if (backingKey == null) {
            return primaryKey;
        }
        TreeSet<K> keySet = new TreeSet<K>();
        keySet.add(backingKey);
        keySet.add(primaryKey);
        return keySet.floor(k);
    }

    @Override
    public boolean isEmpty() {
        if (this.cleared) {
            return true;
        }
        boolean result = this.primary.isEmpty();
        if (result) {
            return this.backingMap.isEmpty();
        }
        return false;
    }

    @Override
    public void drop() {
        if (!this.droppedFlag.get()) {
            this.backingMap.clear();
            this.tombstones.clear();
            this.primary.drop();
            this.cleared = true;
            this.droppedFlag.compareAndSet(false, true);
            this.getStore().removeMap(this.mapName);
        }
    }

    @Override
    public boolean isDropped() {
        return this.droppedFlag.get();
    }

    @Override
    public void close() {
        this.backingMap.clear();
        this.tombstones.clear();
        this.cleared = true;
        this.closedFlag.compareAndSet(false, true);
        this.getStore().closeMap(this.mapName);
    }

    @Override
    public boolean isClosed() {
        if (this.primary.isClosed() || this.primary.isDropped()) {
            return true;
        }
        return this.closedFlag.get();
    }

    private RecordStream<Pair<K, V>> getStream(final RecordStream<Pair<K, V>> primaryStream, final RecordStream<Pair<K, V>> backingStream) {
        if (this.cleared) {
            return RecordStream.empty();
        }
        return () -> new Iterator<Pair<K, V>>(){
            private boolean nextPairSet;
            private final Iterator primaryIterator;
            private final Iterator iterator;
            private Pair nextPair;
            {
                this.primaryIterator = primaryStream.iterator();
                this.iterator = backingStream.iterator();
                this.nextPairSet = false;
            }

            @Override
            public boolean hasNext() {
                return this.nextPairSet || this.setNextId();
            }

            @Override
            public Pair<K, V> next() {
                if (!this.nextPairSet && !this.setNextId()) {
                    throw new NoSuchElementException();
                }
                this.nextPairSet = false;
                return this.nextPair;
            }

            private boolean setNextId() {
                if (this.iterator.hasNext()) {
                    this.nextPair = (Pair)this.iterator.next();
                    this.nextPairSet = true;
                    return true;
                }
                while (this.primaryIterator.hasNext()) {
                    Pair pair = (Pair)this.primaryIterator.next();
                    if (TransactionalMap.this.tombstones.contains(pair.getFirst())) continue;
                    this.nextPair = pair;
                    this.nextPairSet = true;
                    return true;
                }
                return false;
            }
        };
    }
}

