/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import lombok.Generated;
import org.dizitart.no2.common.Constants;
import org.dizitart.no2.common.mapper.EntityConverter;
import org.dizitart.no2.common.mapper.NitriteMapper;
import org.dizitart.no2.common.module.NitriteModule;
import org.dizitart.no2.common.module.PluginManager;
import org.dizitart.no2.exceptions.IndexingException;
import org.dizitart.no2.exceptions.InvalidOperationException;
import org.dizitart.no2.index.NitriteIndexer;
import org.dizitart.no2.migration.Migration;
import org.dizitart.no2.store.NitriteStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NitriteConfig
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"nitrite");
    protected boolean configured = false;
    protected final PluginManager pluginManager;
    private static String fieldSeparator = ".";
    private final List<EntityConverter<?>> entityConverters;
    private final Map<Integer, TreeMap<Integer, Migration>> migrations;
    private Integer schemaVersion = Constants.INITIAL_SCHEMA_VERSION;

    public NitriteConfig() {
        this.migrations = new HashMap<Integer, TreeMap<Integer, Migration>>();
        this.entityConverters = new ArrayList();
        this.pluginManager = new PluginManager(this);
    }

    public void fieldSeparator(String separator) {
        if (this.configured) {
            throw new InvalidOperationException("Cannot change the separator after database initialization");
        }
        fieldSeparator = separator;
    }

    public void registerEntityConverter(EntityConverter<?> entityConverter) {
        if (this.configured) {
            throw new InvalidOperationException("Cannot register entity converter after database initialization");
        }
        this.entityConverters.add(entityConverter);
    }

    public NitriteConfig loadModule(NitriteModule module) {
        if (this.configured) {
            throw new InvalidOperationException("Cannot load module after database initialization");
        }
        this.pluginManager.loadModule(module);
        return this;
    }

    public NitriteConfig addMigration(Migration migration) {
        if (this.configured) {
            throw new InvalidOperationException("Cannot add migration steps after database initialization");
        }
        if (migration != null) {
            int start = migration.getFromVersion();
            int end = migration.getToVersion();
            TreeMap targetMap = this.migrations.computeIfAbsent(start, k -> new TreeMap());
            Migration existing = (Migration)targetMap.get(end);
            if (existing != null) {
                log.warn("Overriding migration " + existing + " with " + migration);
            }
            targetMap.put(end, migration);
        }
        return this;
    }

    public NitriteConfig currentSchemaVersion(Integer version) {
        if (this.configured) {
            throw new InvalidOperationException("Cannot add schema version info after database initialization");
        }
        this.schemaVersion = version;
        return this;
    }

    public void autoConfigure() {
        if (this.configured) {
            throw new InvalidOperationException("Cannot execute autoconfigure after database initialization");
        }
        this.pluginManager.findAndLoadPlugins();
    }

    public NitriteIndexer findIndexer(String indexType) {
        NitriteIndexer nitriteIndexer = this.pluginManager.getIndexerMap().get(indexType);
        if (nitriteIndexer != null) {
            nitriteIndexer.initialize(this);
            return nitriteIndexer;
        }
        throw new IndexingException("No indexer found for index type " + indexType);
    }

    public NitriteMapper nitriteMapper() {
        return this.pluginManager.getNitriteMapper();
    }

    public NitriteStore<?> getNitriteStore() {
        return this.pluginManager.getNitriteStore();
    }

    @Override
    public void close() {
        if (this.pluginManager != null) {
            this.pluginManager.close();
        }
    }

    protected void initialize() {
        this.configured = true;
        this.pluginManager.initializePlugins();
    }

    @Generated
    public String toString() {
        return "NitriteConfig(configured=" + this.configured + ", pluginManager=" + this.getPluginManager() + ", entityConverters=" + this.getEntityConverters() + ", migrations=" + this.getMigrations() + ", schemaVersion=" + this.getSchemaVersion() + ")";
    }

    @Generated
    PluginManager getPluginManager() {
        return this.pluginManager;
    }

    @Generated
    public static String getFieldSeparator() {
        return fieldSeparator;
    }

    @Generated
    public List<EntityConverter<?>> getEntityConverters() {
        return this.entityConverters;
    }

    @Generated
    public Map<Integer, TreeMap<Integer, Migration>> getMigrations() {
        return this.migrations;
    }

    @Generated
    public Integer getSchemaVersion() {
        return this.schemaVersion;
    }
}

