/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.collection;

import java.util.ArrayList;
import java.util.Collections;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.DocumentCursor;
import org.dizitart.no2.collection.FindOptions;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.collection.UpdateOptions;
import org.dizitart.no2.common.PersistentCollection;
import org.dizitart.no2.common.WriteResult;
import org.dizitart.no2.common.util.ValidationUtils;
import org.dizitart.no2.filters.Filter;

public interface NitriteCollection
extends PersistentCollection<Document> {
    default public WriteResult insert(Document document, Document ... documents) {
        ValidationUtils.notNull(document, "a null document cannot be inserted");
        if (documents != null) {
            ValidationUtils.containsNull(documents, "a null document cannot be inserted");
        }
        ArrayList<Document> documentList = new ArrayList<Document>();
        documentList.add(document);
        if (documents != null && documents.length > 0) {
            Collections.addAll(documentList, documents);
        }
        return this.insert(documentList.toArray(new Document[0]));
    }

    default public WriteResult update(Filter filter, Document update) {
        return this.update(filter, update, new UpdateOptions());
    }

    public WriteResult update(Filter var1, Document var2, UpdateOptions var3);

    @Override
    default public WriteResult remove(Filter filter) {
        return this.remove(filter, false);
    }

    public WriteResult remove(Filter var1, boolean var2);

    default public DocumentCursor find() {
        return this.find(Filter.ALL, null);
    }

    default public DocumentCursor find(Filter filter) {
        return this.find(filter, null);
    }

    default public DocumentCursor find(FindOptions findOptions) {
        return this.find(Filter.ALL, findOptions);
    }

    public DocumentCursor find(Filter var1, FindOptions var2);

    public Document getById(NitriteId var1);

    public String getName();
}

