/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.collection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.dizitart.no2.NitriteConfig;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.common.util.Iterables;
import org.dizitart.no2.common.util.ObjectUtils;
import org.dizitart.no2.common.util.StringUtils;
import org.dizitart.no2.common.util.ValidationUtils;
import org.dizitart.no2.exceptions.InvalidIdException;
import org.dizitart.no2.exceptions.InvalidOperationException;
import org.dizitart.no2.exceptions.ValidationException;

class NitriteDocument
extends LinkedHashMap<String, Object>
implements Document {
    private static final long serialVersionUID = 1477462374L;
    private static final List<String> reservedFields = Iterables.listOf("_id", "_revision", "_source", "_modified");

    NitriteDocument() {
    }

    NitriteDocument(Map<String, Object> objectMap) {
        super(objectMap);
    }

    @Override
    public Document put(String field, Object value) {
        if (StringUtils.isNullOrEmpty(field)) {
            throw new InvalidOperationException("Document does not support empty or null key");
        }
        if ("_id".contentEquals(field) && !NitriteId.validId(value)) {
            throw new InvalidOperationException("_id is an auto generated value and cannot be set");
        }
        if (value != null && !Serializable.class.isAssignableFrom(value.getClass())) {
            throw new ValidationException("Type " + value.getClass().getName() + " does not implement java.io.Serializable");
        }
        if (this.isEmbedded(field)) {
            String regex = MessageFormat.format("\\{0}", NitriteConfig.getFieldSeparator());
            String[] splits = field.split(regex);
            this.deepPut(splits, value);
        } else {
            super.put(field, value);
        }
        return this;
    }

    @Override
    public Object get(String field) {
        if (field != null && this.isEmbedded(field) && !this.containsKey(field)) {
            return this.deepGet(field);
        }
        return super.get(field);
    }

    @Override
    public <T> T get(String field, Class<T> type) {
        ValidationUtils.notNull(type, "type cannot be null");
        return type.cast(this.get(field));
    }

    @Override
    public NitriteId getId() {
        try {
            String id;
            if (!this.containsKey("_id")) {
                id = NitriteId.newId().getIdValue();
                super.put("_id", id);
            } else {
                id = (String)this.get("_id");
            }
            return NitriteId.createId(id);
        }
        catch (ClassCastException cce) {
            throw new InvalidIdException("Invalid _id found " + this.get("_id"));
        }
    }

    @Override
    public Set<String> getFields() {
        return this.getFieldsInternal("");
    }

    @Override
    public boolean hasId() {
        return super.containsKey("_id");
    }

    @Override
    public void remove(String field) {
        if (this.isEmbedded(field)) {
            String regex = MessageFormat.format("\\{0}", NitriteConfig.getFieldSeparator());
            String[] splits = field.split(regex);
            this.deepRemove(splits);
        } else {
            super.remove(field);
        }
    }

    @Override
    public Document clone() {
        Map cloned = (Map)super.clone();
        for (Map.Entry entry : cloned.entrySet()) {
            if (!(entry.getValue() instanceof Document)) continue;
            Document value = (Document)entry.getValue();
            Document clonedValue = value.clone();
            cloned.put((String)entry.getKey(), clonedValue);
        }
        return new NitriteDocument(cloned);
    }

    @Override
    public Document merge(Document document) {
        if (document instanceof NitriteDocument) {
            NitriteDocument nitriteDocument = (NitriteDocument)document;
            for (Pair<String, Object> entry : nitriteDocument) {
                String key = entry.getFirst();
                Object value = entry.getSecond();
                if (value instanceof NitriteDocument) {
                    if (this.containsKey(key)) {
                        this.get(key, Document.class).merge((Document)value);
                        continue;
                    }
                    this.put(key, value);
                    continue;
                }
                this.put(key, value);
            }
        } else {
            throw new InvalidOperationException("Document merge only supports NitriteDocument");
        }
        return this;
    }

    @Override
    public boolean containsKey(String key) {
        return super.containsKey(key);
    }

    @Override
    public boolean containsField(String field) {
        if (this.containsKey(field)) {
            return true;
        }
        return this.getFields().contains(field);
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof NitriteDocument)) {
            return false;
        }
        NitriteDocument m = (NitriteDocument)other;
        if (m.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry e : this.entrySet()) {
                String key = (String)e.getKey();
                Object value = e.getValue();
                if (!(value == null ? m.get(key) != null || !m.containsKey(key) : !Objects.deepEquals(value, m.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException | NullPointerException unused) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public Iterator<Pair<String, Object>> iterator() {
        return new PairIterator(super.entrySet().iterator());
    }

    private Set<String> getFieldsInternal(String prefix) {
        HashSet<String> fields = new HashSet<String>();
        for (Pair<String, Object> entry : this) {
            if (reservedFields.contains(entry.getFirst())) continue;
            Object value = entry.getSecond();
            if (value instanceof NitriteDocument) {
                if (StringUtils.isNullOrEmpty(prefix)) {
                    fields.addAll(((NitriteDocument)value).getFieldsInternal(entry.getFirst()));
                    continue;
                }
                fields.addAll(((NitriteDocument)value).getFieldsInternal(prefix + NitriteConfig.getFieldSeparator() + entry.getFirst()));
                continue;
            }
            if (value instanceof Iterable) continue;
            if (StringUtils.isNullOrEmpty(prefix)) {
                fields.add(entry.getFirst());
                continue;
            }
            fields.add(prefix + NitriteConfig.getFieldSeparator() + entry.getFirst());
        }
        return fields;
    }

    private Object deepGet(String field) {
        if (this.isEmbedded(field)) {
            return this.getByEmbeddedKey(field);
        }
        return null;
    }

    private void deepPut(String[] splits, Object value) {
        if (splits.length == 0) {
            throw new ValidationException("Invalid key provided");
        }
        String key = splits[0];
        if (splits.length == 1) {
            this.put(key, value);
        } else {
            Object val = this.get(key);
            String[] remaining = Arrays.copyOfRange(splits, 1, splits.length);
            if (val instanceof NitriteDocument) {
                ((NitriteDocument)val).deepPut(remaining, value);
            } else if (val == null) {
                NitriteDocument subDoc = new NitriteDocument();
                subDoc.deepPut(remaining, value);
                this.put(key, (Object)subDoc);
            }
        }
    }

    private void deepRemove(String[] splits) {
        if (splits.length == 0) {
            throw new ValidationException("Invalid key provided");
        }
        String key = splits[0];
        if (splits.length == 1) {
            this.remove(key);
        } else {
            Object val = this.get(key);
            String[] remaining = Arrays.copyOfRange(splits, 1, splits.length);
            if (val instanceof NitriteDocument) {
                NitriteDocument subDoc = (NitriteDocument)val;
                subDoc.deepRemove(remaining);
                if (subDoc.size() == 0) {
                    super.remove(key);
                }
            } else if (val instanceof List && this.isInteger(splits[1])) {
                List list = (List)val;
                int index = Integer.parseInt(splits[1]);
                Object item = list.get(index);
                if (splits.length > 2 && item instanceof NitriteDocument) {
                    ((NitriteDocument)item).deepRemove(Arrays.copyOfRange(splits, 2, splits.length));
                } else {
                    list.remove(index);
                    this.put(key, (Object)list);
                }
            } else if (val != null && val.getClass().isArray()) {
                Object[] array = ObjectUtils.convertToObjectArray(val);
                int index = Integer.parseInt(splits[1]);
                Object item = array[index];
                if (splits.length > 2 && item instanceof NitriteDocument) {
                    ((NitriteDocument)item).deepRemove(Arrays.copyOfRange(splits, 2, splits.length));
                } else {
                    List<Object> list = Arrays.asList(array);
                    list.remove(index);
                    this.put(key, (Object)list.toArray());
                }
            } else {
                super.remove(key);
            }
        }
    }

    private Object getByEmbeddedKey(String embeddedKey) {
        String regex = MessageFormat.format("\\{0}", NitriteConfig.getFieldSeparator());
        String[] path = embeddedKey.split(regex);
        if (path.length < 1) {
            return null;
        }
        return this.recursiveGet(this.get(path[0]), Arrays.copyOfRange(path, 1, path.length));
    }

    private Object recursiveGet(Object object, String[] remainingPath) {
        if (object == null) {
            return null;
        }
        if (remainingPath.length == 0) {
            return object;
        }
        if (object instanceof Document) {
            return this.recursiveGet(((Document)object).get(remainingPath[0]), Arrays.copyOfRange(remainingPath, 1, remainingPath.length));
        }
        if (object.getClass().isArray()) {
            String accessor = remainingPath[0];
            Object[] array = ObjectUtils.convertToObjectArray(object);
            if (this.isInteger(accessor)) {
                int index = this.asInteger(accessor);
                if (index < 0 || index >= array.length) {
                    throw new ValidationException("Invalid index " + index + " to access item inside a document");
                }
                return this.recursiveGet(array[index], Arrays.copyOfRange(remainingPath, 1, remainingPath.length));
            }
            return this.decompose(Iterables.listOf(array), remainingPath);
        }
        if (object instanceof Iterable) {
            String accessor = remainingPath[0];
            Iterable iterable = (Iterable)object;
            List<Object> collection = Iterables.toList(iterable);
            if (this.isInteger(accessor)) {
                int index = this.asInteger(accessor);
                if (index < 0 || index >= collection.size()) {
                    throw new ValidationException("Invalid index " + index + " to access item inside a document");
                }
                return this.recursiveGet(collection.get(index), Arrays.copyOfRange(remainingPath, 1, remainingPath.length));
            }
            return this.decompose(collection, remainingPath);
        }
        return null;
    }

    private List<Object> decompose(List<Object> collection, String[] remainingPath) {
        HashSet<Object> items = new HashSet<Object>();
        for (Object item : collection) {
            List<Object> list;
            Object result = this.recursiveGet(item, remainingPath);
            if (result == null) continue;
            if (result instanceof Iterable) {
                list = Iterables.toList((Iterable)result);
                items.addAll(list);
                continue;
            }
            if (result.getClass().isArray()) {
                list = Arrays.asList(ObjectUtils.convertToObjectArray(result));
                items.addAll(list);
                continue;
            }
            items.add(result);
        }
        return new ArrayList<Object>(items);
    }

    private int asInteger(String number) {
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isEmbedded(String field) {
        return field.contains(NitriteConfig.getFieldSeparator());
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(this.size());
        for (Pair<String, Object> pair : this) {
            stream.writeObject(pair);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int size = stream.readInt();
        for (int i = 0; i < size; ++i) {
            Pair pair = (Pair)stream.readObject();
            super.put((String)pair.getFirst(), pair.getSecond());
        }
    }

    private static class PairIterator
    implements Iterator<Pair<String, Object>> {
        private final Iterator<Map.Entry<String, Object>> iterator;

        PairIterator(Iterator<Map.Entry<String, Object>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Pair<String, Object> next() {
            Map.Entry<String, Object> next = this.iterator.next();
            return new Pair<String, Object>(next.getKey(), next.getValue());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

