/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.collection.operation;

import java.util.ArrayList;
import lombok.Generated;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.DocumentCursor;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.collection.UpdateOptions;
import org.dizitart.no2.collection.events.CollectionEventInfo;
import org.dizitart.no2.collection.events.CollectionEventListener;
import org.dizitart.no2.collection.events.EventType;
import org.dizitart.no2.collection.operation.DocumentIndexWriter;
import org.dizitart.no2.collection.operation.ReadOperations;
import org.dizitart.no2.collection.operation.WriteResultImpl;
import org.dizitart.no2.common.WriteResult;
import org.dizitart.no2.common.event.EventBus;
import org.dizitart.no2.common.processors.ProcessorChain;
import org.dizitart.no2.exceptions.IndexingException;
import org.dizitart.no2.exceptions.UniqueConstraintException;
import org.dizitart.no2.filters.Filter;
import org.dizitart.no2.store.NitriteMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WriteOperations {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"nitrite");
    private final DocumentIndexWriter documentIndexWriter;
    private final ReadOperations readOperations;
    private final EventBus<CollectionEventInfo<?>, CollectionEventListener> eventBus;
    private final NitriteMap<NitriteId, Document> nitriteMap;
    private final ProcessorChain processorChain;

    WriteOperations(DocumentIndexWriter documentIndexWriter, ReadOperations readOperations, NitriteMap<NitriteId, Document> nitriteMap, EventBus<CollectionEventInfo<?>, CollectionEventListener> eventBus, ProcessorChain processorChain) {
        this.documentIndexWriter = documentIndexWriter;
        this.readOperations = readOperations;
        this.eventBus = eventBus;
        this.nitriteMap = nitriteMap;
        this.processorChain = processorChain;
    }

    WriteResult insert(Document ... documents) {
        ArrayList<NitriteId> nitriteIds = new ArrayList<NitriteId>(documents.length);
        log.debug("Total {} document(s) to be inserted in {}", (Object)documents.length, (Object)this.nitriteMap.getName());
        for (Document document : documents) {
            Document newDoc = document.clone();
            NitriteId nitriteId = newDoc.getId();
            String source = newDoc.getSource();
            long time = System.currentTimeMillis();
            if (!"Replicator.NO\u2082".contentEquals(newDoc.getSource())) {
                newDoc.remove("_source");
                newDoc.put("_revision", 1);
                newDoc.put("_modified", time);
            } else {
                newDoc.remove("_source");
            }
            Document unprocessed = newDoc.clone();
            Document processed = this.processorChain.processBeforeWrite(unprocessed);
            log.debug("Processed document with id: {}", (Object)nitriteId);
            log.debug("Inserting processed document with id {}", (Object)nitriteId);
            Document already = this.nitriteMap.putIfAbsent(nitriteId, processed);
            if (already != null) {
                throw new UniqueConstraintException("Document with id " + nitriteId + " already exists in " + this.nitriteMap.getName());
            }
            try {
                this.documentIndexWriter.writeIndexEntry(processed);
            }
            catch (IndexingException | UniqueConstraintException e) {
                log.error("Error while writing index entry for document with id : {} in {}", new Object[]{nitriteId, this.nitriteMap.getName(), e});
                this.nitriteMap.remove(nitriteId);
                throw e;
            }
            nitriteIds.add(nitriteId);
            CollectionEventInfo<Document> eventInfo = new CollectionEventInfo<Document>();
            eventInfo.setItem(newDoc);
            eventInfo.setTimestamp(time);
            eventInfo.setEventType(EventType.Insert);
            eventInfo.setOriginator(source);
            this.alert(eventInfo);
        }
        WriteResultImpl result = new WriteResultImpl();
        result.setNitriteIds(nitriteIds);
        log.debug("Returning write result {} for collection {}", (Object)result, (Object)this.nitriteMap.getName());
        return result;
    }

    WriteResult update(Filter filter, Document update, UpdateOptions updateOptions) {
        DocumentCursor cursor = this.readOperations.find(filter, null);
        WriteResultImpl writeResult = new WriteResultImpl();
        Document document = update.clone();
        document.remove("_id");
        if (!"Replicator.NO\u2082".contentEquals(document.getSource())) {
            document.remove("_revision");
        }
        if (document.size() == 0) {
            log.debug("No fields to update");
            return writeResult;
        }
        long count = 0L;
        for (Document doc : cursor) {
            if (doc == null) continue;
            if (++count > 1L && updateOptions.isJustOnce()) break;
            Document newDoc = doc.clone();
            Document oldDocument = doc.clone();
            String source = document.getSource();
            long time = System.currentTimeMillis();
            NitriteId nitriteId = newDoc.getId();
            log.debug("Updating document with id {} in {}", (Object)nitriteId, (Object)this.nitriteMap.getName());
            if (!"Replicator.NO\u2082".contentEquals(document.getSource())) {
                document.remove("_source");
                newDoc.merge(document);
                int rev = newDoc.getRevision();
                newDoc.put("_revision", rev + 1);
                newDoc.put("_modified", time);
            } else {
                document.remove("_source");
                newDoc.merge(document);
            }
            Document unprocessed = newDoc.clone();
            Document processed = this.processorChain.processBeforeWrite(unprocessed);
            log.debug("Processed document with id {}", (Object)nitriteId);
            this.nitriteMap.put(nitriteId, processed);
            log.debug("Updated document with id {} in {}", (Object)nitriteId, (Object)this.nitriteMap.getName());
            try {
                this.documentIndexWriter.updateIndexEntry(oldDocument, processed, document);
                if (document.size() > 0) {
                    writeResult.addToList(nitriteId);
                }
            }
            catch (IndexingException | UniqueConstraintException e) {
                log.error("Error while writing index entry for document with id : {} in {}", new Object[]{nitriteId, this.nitriteMap.getName(), e});
                this.nitriteMap.put(nitriteId, oldDocument);
                this.documentIndexWriter.updateIndexEntry(processed, oldDocument, document);
                throw e;
            }
            CollectionEventInfo<Document> eventInfo = new CollectionEventInfo<Document>();
            eventInfo.setItem(newDoc);
            eventInfo.setEventType(EventType.Update);
            eventInfo.setTimestamp(time);
            eventInfo.setOriginator(source);
            this.alert(eventInfo);
        }
        if (count == 0L) {
            log.debug("No documents found for update in {}", (Object)this.nitriteMap.getName());
            if (updateOptions.isInsertIfAbsent()) {
                return this.insert(update);
            }
            return writeResult;
        }
        log.debug("Updated {} documents in {}", (Object)count, (Object)this.nitriteMap.getName());
        log.debug("Returning write result {} for collection {}", (Object)writeResult, (Object)this.nitriteMap.getName());
        return writeResult;
    }

    WriteResult remove(Filter filter, boolean justOnce) {
        DocumentCursor cursor = this.readOperations.find(filter, null);
        WriteResultImpl result = new WriteResultImpl();
        long count = 0L;
        for (Document document : cursor) {
            if (document == null) continue;
            ++count;
            Document unprocessed = document.clone();
            Document processed = this.processorChain.processAfterRead(unprocessed);
            log.debug("Processed document with id : {}", (Object)processed.getId());
            CollectionEventInfo<Document> eventInfo = this.removeAndCreateEvent(processed, result);
            if (eventInfo != null) {
                this.alert(eventInfo);
            }
            if (!justOnce) continue;
            break;
        }
        if (count == 0L) {
            log.debug("No documents found for filter {}", (Object)filter);
            return result;
        }
        log.debug("Removed {} documents for filter : {}", (Object)count, (Object)filter);
        return result;
    }

    WriteResult remove(Document document) {
        WriteResultImpl result = new WriteResultImpl();
        CollectionEventInfo<Document> eventInfo = this.removeAndCreateEvent(document, result);
        if (eventInfo != null) {
            eventInfo.setOriginator(document.getSource());
            this.alert(eventInfo);
        }
        return result;
    }

    private CollectionEventInfo<Document> removeAndCreateEvent(Document document, WriteResultImpl writeResult) {
        NitriteId nitriteId = document.getId();
        if ((document = this.nitriteMap.remove(nitriteId)) != null) {
            long removedAt = System.currentTimeMillis();
            this.documentIndexWriter.removeIndexEntry(document);
            writeResult.addToList(nitriteId);
            int rev = document.getRevision();
            document.put("_revision", rev + 1);
            document.put("_modified", removedAt);
            log.debug("Removed document with id {} from {}", (Object)document, (Object)this.nitriteMap.getName());
            CollectionEventInfo<Document> eventInfo = new CollectionEventInfo<Document>();
            Document eventDoc = document.clone();
            eventInfo.setItem(eventDoc);
            eventInfo.setEventType(EventType.Remove);
            eventInfo.setTimestamp(removedAt);
            return eventInfo;
        }
        return null;
    }

    private void alert(CollectionEventInfo<?> changedItem) {
        log.debug("Alerting event listeners for action : {} in {}", (Object)changedItem.getEventType(), (Object)this.nitriteMap.getName());
        if (this.eventBus != null) {
            this.eventBus.post(changedItem);
        }
    }
}

