/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.dizitart.no2.exceptions.NitriteIOException;

public class Constants {
    public static final String NITRITE_VERSION;
    public static final String INDEX_META_PREFIX = "$nitrite_index_meta";
    public static final String INDEX_PREFIX = "$nitrite_index";
    public static final String INTERNAL_NAME_SEPARATOR = "|";
    public static final String USER_MAP = "$nitrite_users";
    public static final String OBJECT_STORE_NAME_SEPARATOR = ":";
    public static final String META_MAP_NAME = "$nitrite_meta_map";
    public static final String STORE_INFO = "$nitrite_store_info";
    public static final String COLLECTION_CATALOG = "$nitrite_catalog";
    public static final String KEY_OBJ_SEPARATOR = "+";
    public static final List<String> RESERVED_NAMES;
    public static final String ID_PREFIX = "[";
    public static final String TAG_COLLECTIONS = "collections";
    public static final String TAG_REPOSITORIES = "repositories";
    public static final String TAG_KEYED_REPOSITORIES = "keyed-repositories";
    public static final String TAG_MAP_METADATA = "mapNames";
    public static final String TAG_TYPE = "type";
    public static final String TAG_INDICES = "indices";
    public static final String TAG_INDEX = "index";
    public static final String TAG_DATA = "data";
    public static final String TAG_NAME = "name";
    public static final String TAG_KEY = "key";
    public static final String TAG_VALUE = "value";
    public static final String DOC_ID = "_id";
    public static final String DOC_REVISION = "_revision";
    public static final String DOC_MODIFIED = "_modified";
    public static final String DOC_SOURCE = "_source";
    public static final int HASH_ITERATIONS = 10000;
    public static final int HASH_KEY_LENGTH = 256;
    private static final String NO2 = "NO\u2082";
    public static final String ID_SUFFIX = "]NO\u2082";
    public static final String REPLICATOR = "Replicator.NO\u2082";
    public static final String DAEMON_THREAD_NAME = "Worker.NO\u2082";
    public static final String SYNC_THREAD_NAME = "Sync.NO\u2082";
    public static final Integer INITIAL_SCHEMA_VERSION;

    private Constants() {
    }

    static {
        String v;
        block18: {
            v = "unknown";
            try (InputStream is = ClassLoader.getSystemClassLoader().getResourceAsStream("version");){
                if (is == null) break block18;
                try (InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);
                     BufferedReader bufferedReader = new BufferedReader(reader);){
                    v = bufferedReader.readLine();
                }
            }
            catch (IOException e) {
                throw new NitriteIOException("Failed to load version information", e);
            }
        }
        NITRITE_VERSION = v;
        RESERVED_NAMES = Arrays.asList(INDEX_META_PREFIX, INDEX_PREFIX, INTERNAL_NAME_SEPARATOR, USER_MAP, OBJECT_STORE_NAME_SEPARATOR, META_MAP_NAME, STORE_INFO, COLLECTION_CATALOG, KEY_OBJ_SEPARATOR);
        INITIAL_SCHEMA_VERSION = 1;
    }
}

