/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.common;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.dizitart.no2.common.util.Iterables;

public interface RecordStream<T>
extends Iterable<T> {
    public static <T> RecordStream<T> fromIterable(Iterable<T> iterable) {
        return iterable::iterator;
    }

    public static <T> RecordStream<T> fromCombined(final Iterable<T> first, final Iterable<T> second) {
        return RecordStream.fromIterable(() -> new Iterator<T>(){
            private final Iterator firstIterator;
            private final Iterator secondIterator;
            {
                this.firstIterator = first != null ? first.iterator() : Collections.emptyIterator();
                this.secondIterator = second != null ? second.iterator() : Collections.emptyIterator();
            }

            @Override
            public boolean hasNext() {
                boolean result = this.firstIterator.hasNext();
                if (!result) {
                    return this.secondIterator.hasNext();
                }
                return true;
            }

            @Override
            public T next() {
                Object next;
                Object t = next = this.firstIterator.hasNext() ? (Object)this.firstIterator.next() : null;
                if (next == null) {
                    return this.secondIterator.next();
                }
                return next;
            }
        });
    }

    public static <T> RecordStream<T> except(final Iterable<T> iterable, final Collection<T> elements) {
        return RecordStream.fromIterable(() -> new Iterator<T>(){
            private boolean nextItemSet;
            private final Iterator iterator;
            private Object nextItem;
            {
                this.iterator = iterable != null ? iterable.iterator() : Collections.emptyIterator();
                this.nextItemSet = false;
            }

            @Override
            public boolean hasNext() {
                return this.nextItemSet || this.setNextId();
            }

            @Override
            public T next() {
                if (!this.nextItemSet && !this.setNextId()) {
                    throw new NoSuchElementException();
                }
                this.nextItemSet = false;
                return this.nextItem;
            }

            private boolean setNextId() {
                while (this.iterator.hasNext()) {
                    Object item = this.iterator.next();
                    if (elements.contains(item)) continue;
                    this.nextItem = item;
                    this.nextItemSet = true;
                    return true;
                }
                return false;
            }
        });
    }

    public static <V> RecordStream<V> empty() {
        return RecordStream.fromIterable(Collections.emptySet());
    }

    public static <V> RecordStream<V> single(V v) {
        return RecordStream.fromIterable(Collections.singleton(v));
    }

    default public long size() {
        return Iterables.size(this);
    }

    default public List<T> toList() {
        return Collections.unmodifiableList(Iterables.toList(this));
    }

    default public Set<T> toSet() {
        return Collections.unmodifiableSet(Iterables.toSet(this));
    }

    default public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    default public T firstOrNull() {
        return Iterables.firstOrNull(this);
    }
}

