/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.common.event;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import org.dizitart.no2.common.concurrent.ThreadPoolManager;
import org.dizitart.no2.common.event.EventBus;

public abstract class NitriteEventBus<EventInfo, EventListener>
implements EventBus<EventInfo, EventListener> {
    private final Set<EventListener> listeners = new CopyOnWriteArraySet<EventListener>();
    private ExecutorService eventExecutor;

    @Override
    public void register(EventListener eventListener) {
        if (eventListener != null) {
            this.listeners.add(eventListener);
        }
    }

    @Override
    public void deregister(EventListener eventListener) {
        if (eventListener != null) {
            this.listeners.remove(eventListener);
        }
    }

    @Override
    public void close() {
        this.listeners.clear();
        if (this.eventExecutor != null) {
            this.eventExecutor.shutdown();
        }
    }

    protected ExecutorService getEventExecutor() {
        if (this.eventExecutor == null || this.eventExecutor.isShutdown() || this.eventExecutor.isTerminated()) {
            this.eventExecutor = ThreadPoolManager.workerPool();
        }
        return this.eventExecutor;
    }

    protected Set<EventListener> getListeners() {
        return this.listeners;
    }
}

