/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.common.streams;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.RecordStream;
import org.dizitart.no2.common.tuples.Pair;

public class ConcatStream
implements RecordStream<Pair<NitriteId, Document>> {
    private final Collection<RecordStream<Pair<NitriteId, Document>>> streams;

    public ConcatStream(Collection<RecordStream<Pair<NitriteId, Document>>> streams) {
        this.streams = streams;
    }

    @Override
    public Iterator<Pair<NitriteId, Document>> iterator() {
        LinkedList<Iterator<Pair<NitriteId, Document>>> iteratorQueue = new LinkedList<Iterator<Pair<NitriteId, Document>>>();
        for (RecordStream<Pair<NitriteId, Document>> stream : this.streams) {
            iteratorQueue.add(stream.iterator());
        }
        return new UnionStreamIterator(iteratorQueue);
    }

    private static class UnionStreamIterator
    implements Iterator<Pair<NitriteId, Document>> {
        private final Queue<Iterator<Pair<NitriteId, Document>>> iteratorQueue;
        private Iterator<Pair<NitriteId, Document>> currentIterator;

        public UnionStreamIterator(Queue<Iterator<Pair<NitriteId, Document>>> iteratorQueue) {
            this.iteratorQueue = iteratorQueue;
        }

        @Override
        public boolean hasNext() {
            this.updateCurrentIterator();
            return this.currentIterator.hasNext();
        }

        @Override
        public Pair<NitriteId, Document> next() {
            this.updateCurrentIterator();
            return this.currentIterator.next();
        }

        private void updateCurrentIterator() {
            if (this.currentIterator == null) {
                this.currentIterator = this.iteratorQueue.isEmpty() ? Collections.emptyIterator() : this.iteratorQueue.remove();
            }
            while (!this.currentIterator.hasNext() && !this.iteratorQueue.isEmpty()) {
                this.currentIterator = this.iteratorQueue.remove();
            }
        }
    }
}

