/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.common.streams;

import java.util.Collections;
import java.util.Iterator;
import lombok.Generated;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.DocumentCursor;
import org.dizitart.no2.collection.FindPlan;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.Lookup;
import org.dizitart.no2.common.RecordStream;
import org.dizitart.no2.common.processors.ProcessorChain;
import org.dizitart.no2.common.streams.JoinedDocumentStream;
import org.dizitart.no2.common.streams.ProjectedDocumentStream;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.exceptions.InvalidOperationException;
import org.dizitart.no2.exceptions.ValidationException;

public class DocumentStream
implements DocumentCursor {
    private final RecordStream<Pair<NitriteId, Document>> recordStream;
    private final ProcessorChain processorChain;
    private FindPlan findPlan;

    public DocumentStream(RecordStream<Pair<NitriteId, Document>> recordStream, ProcessorChain processorChain) {
        this.recordStream = recordStream;
        this.processorChain = processorChain;
    }

    @Override
    public RecordStream<Document> project(Document projection) {
        this.validateProjection(projection);
        return new ProjectedDocumentStream(this.recordStream, projection, this.processorChain);
    }

    @Override
    public RecordStream<Document> join(DocumentCursor foreignCursor, Lookup lookup) {
        return new JoinedDocumentStream(this.recordStream, foreignCursor, lookup, this.processorChain);
    }

    @Override
    public Iterator<Document> iterator() {
        Iterator<Pair<NitriteId, Document>> iterator = this.recordStream == null ? Collections.emptyIterator() : this.recordStream.iterator();
        return new DocumentCursorIterator(iterator, this.processorChain);
    }

    private void validateProjection(Document projection) {
        for (Pair kvp : projection) {
            this.validateKeyValuePair(kvp);
        }
    }

    private void validateKeyValuePair(Pair<String, Object> kvp) {
        if (kvp.getSecond() != null) {
            if (!(kvp.getSecond() instanceof Document)) {
                throw new ValidationException("Projection contains non-null values");
            }
            this.validateProjection((Document)kvp.getSecond());
        }
    }

    @Override
    @Generated
    public FindPlan getFindPlan() {
        return this.findPlan;
    }

    @Generated
    public void setFindPlan(FindPlan findPlan) {
        this.findPlan = findPlan;
    }

    private static class DocumentCursorIterator
    implements Iterator<Document> {
        private final Iterator<Pair<NitriteId, Document>> iterator;
        private final ProcessorChain processorChain;

        DocumentCursorIterator(Iterator<Pair<NitriteId, Document>> iterator, ProcessorChain processorChain) {
            this.iterator = iterator;
            this.processorChain = processorChain;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Document next() {
            Pair<NitriteId, Document> next = this.iterator.next();
            Document document = next.getSecond();
            if (document != null) {
                Document copy = document.clone();
                copy = this.processorChain.processAfterRead(copy);
                return copy;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new InvalidOperationException("Remove on cursor is not supported");
        }
    }
}

