/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.common.streams;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.RecordStream;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.exceptions.InvalidOperationException;
import org.dizitart.no2.filters.Filter;

public class FilteredStream
implements RecordStream<Pair<NitriteId, Document>> {
    private final RecordStream<Pair<NitriteId, Document>> recordStream;
    private final Filter filter;

    public FilteredStream(RecordStream<Pair<NitriteId, Document>> recordStream, Filter filter) {
        this.recordStream = recordStream;
        this.filter = filter;
    }

    @Override
    public Iterator<Pair<NitriteId, Document>> iterator() {
        Iterator<Pair<NitriteId, Document>> iterator;
        Iterator<Pair<NitriteId, Document>> iterator2 = iterator = this.recordStream == null ? Collections.emptyIterator() : this.recordStream.iterator();
        if (this.filter == null || this.filter == Filter.ALL) {
            return iterator;
        }
        return new FilteredIterator(iterator, this.filter);
    }

    private static class FilteredIterator
    implements Iterator<Pair<NitriteId, Document>> {
        private final Iterator<Pair<NitriteId, Document>> iterator;
        private final Filter filter;
        private Pair<NitriteId, Document> nextPair;
        private boolean nextPairSet = false;

        public FilteredIterator(Iterator<Pair<NitriteId, Document>> iterator, Filter filter) {
            this.iterator = iterator;
            this.filter = filter;
        }

        @Override
        public boolean hasNext() {
            return this.nextPairSet || this.setNextId();
        }

        @Override
        public Pair<NitriteId, Document> next() {
            if (!this.nextPairSet && !this.setNextId()) {
                throw new NoSuchElementException();
            }
            this.nextPairSet = false;
            return this.nextPair;
        }

        @Override
        public void remove() {
            if (this.nextPairSet) {
                throw new InvalidOperationException("Remove operation cannot be called here");
            }
            this.iterator.remove();
        }

        private boolean setNextId() {
            while (this.iterator.hasNext()) {
                Pair<NitriteId, Document> pair = this.iterator.next();
                if (!this.filter.apply(pair)) continue;
                this.nextPair = pair;
                this.nextPairSet = true;
                return true;
            }
            return false;
        }
    }
}

