/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.common.streams;

import java.util.Iterator;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.common.RecordStream;
import org.dizitart.no2.common.mapper.NitriteMapper;
import org.dizitart.no2.exceptions.InvalidOperationException;

public class MutatedObjectStream<T>
implements RecordStream<T> {
    private final RecordStream<Document> recordIterable;
    private final Class<T> mutationType;
    private final NitriteMapper nitriteMapper;

    public MutatedObjectStream(NitriteMapper nitriteMapper, RecordStream<Document> recordIterable, Class<T> mutationType) {
        this.recordIterable = recordIterable;
        this.mutationType = mutationType;
        this.nitriteMapper = nitriteMapper;
    }

    @Override
    public Iterator<T> iterator() {
        return new MutatedObjectIterator(this.nitriteMapper);
    }

    private class MutatedObjectIterator
    implements Iterator<T> {
        private final NitriteMapper nitriteMapper;
        private final Iterator<Document> documentIterator;

        MutatedObjectIterator(NitriteMapper nitriteMapper) {
            this.nitriteMapper = nitriteMapper;
            this.documentIterator = MutatedObjectStream.this.recordIterable.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.documentIterator.hasNext();
        }

        @Override
        public T next() {
            Document item = this.documentIterator.next();
            if (item != null) {
                Document record = item.clone();
                record.remove("_id");
                return this.nitriteMapper.tryConvert(record, MutatedObjectStream.this.mutationType);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new InvalidOperationException("Remove on a cursor is not supported");
        }
    }
}

