/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.common.mapper.NitriteMapper;
import org.dizitart.no2.common.util.Iterables;
import org.dizitart.no2.common.util.Numbers;
import org.dizitart.no2.common.util.StringUtils;
import org.dizitart.no2.exceptions.NitriteIOException;
import org.dizitart.no2.exceptions.ObjectMappingException;
import org.dizitart.no2.exceptions.ValidationException;
import org.dizitart.no2.repository.EntityDecorator;
import org.dizitart.no2.repository.annotations.Entity;

public class ObjectUtils {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER_TYPE;

    private ObjectUtils() {
    }

    public static <T> String getEntityName(Class<T> type) {
        if (type.isAnnotationPresent(Entity.class)) {
            Entity entity = type.getAnnotation(Entity.class);
            String name = entity.value();
            if (name.contains("+")) {
                throw new ValidationException(name + " is not a valid entity name");
            }
            if (!StringUtils.isNullOrEmpty(name)) {
                return entity.value();
            }
        }
        return type.getName();
    }

    public static <T> String findRepositoryName(Class<T> type, String key) {
        return ObjectUtils.findRepositoryName(ObjectUtils.getEntityName(type), key);
    }

    public static String findRepositoryName(String entityName, String key) {
        if (StringUtils.isNullOrEmpty(key)) {
            return entityName;
        }
        return entityName + "+" + key;
    }

    public static <T> String findRepositoryNameByDecorator(EntityDecorator<T> entityDecorator, String key) {
        String entityName = entityDecorator.getEntityName();
        if (entityName.contains("+")) {
            throw new ValidationException(entityName + " is not a valid entity name");
        }
        return ObjectUtils.findRepositoryName(entityName, key);
    }

    public static String getKeyName(String collectionName) {
        if (collectionName.contains("+")) {
            String[] split = collectionName.split("\\+");
            return split[1];
        }
        throw new ValidationException(collectionName + " is not a valid keyed object repository");
    }

    public static String getKeyedRepositoryType(String collectionName) {
        if (collectionName.contains("+")) {
            String[] split = collectionName.split("\\+");
            return split[0];
        }
        throw new ValidationException(collectionName + " is not a valid keyed object repository");
    }

    public static boolean deepEquals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1 == o2) {
            return true;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            if (o1.getClass() != o2.getClass()) {
                return false;
            }
            return Numbers.compare((Number)o1, (Number)o2) == 0;
        }
        if (o1 instanceof Iterable && o2 instanceof Iterable) {
            Object[] arr1 = Iterables.toArray((Iterable)o1);
            Object[] arr2 = Iterables.toArray((Iterable)o2);
            return ObjectUtils.deepEquals(arr1, arr2);
        }
        if (o1.getClass().isArray() && o2.getClass().isArray()) {
            int length = Array.getLength(o1);
            if (length != Array.getLength(o2)) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                Object item2;
                Object item1 = Array.get(o1, i);
                if (ObjectUtils.deepEquals(item1, item2 = Array.get(o2, i))) continue;
                return false;
            }
            return true;
        }
        if (o1 instanceof Map && o2 instanceof Map) {
            Map map1 = (Map)o1;
            Map map2 = (Map)o2;
            return ObjectUtils.deepEquals(Iterables.toArray(map1.entrySet()), Iterables.toArray(map2.entrySet()));
        }
        return o1.equals(o2);
    }

    public static <T> Object newInstance(Class<T> type, boolean createSkeleton, NitriteMapper nitriteMapper) {
        try {
            if (type.isPrimitive() || type.isArray() || type == String.class || ObjectUtils.isBuiltInValueType(type)) {
                return ObjectUtils.defaultValue(type);
            }
            Object item = nitriteMapper.tryConvert(Document.createDocument(), type);
            if (createSkeleton) {
                Field[] fields;
                for (Field field : fields = type.getDeclaredFields()) {
                    if (Modifier.isStatic(field.getModifiers())) continue;
                    field.setAccessible(true);
                    if (ObjectUtils.isSkeletonRequired(type, field.getType())) {
                        field.set(item, ObjectUtils.newInstance(field.getType(), true, nitriteMapper));
                        continue;
                    }
                    field.set(item, ObjectUtils.defaultValue(field.getType()));
                }
            }
            return item;
        }
        catch (Throwable e) {
            throw new ObjectMappingException("Failed to instantiate type " + type.getName(), e);
        }
    }

    public static boolean isBuiltInValueType(Class<?> retType) {
        if (retType.isPrimitive() && retType != Void.TYPE) {
            return true;
        }
        if (Number.class.isAssignableFrom(retType)) {
            return true;
        }
        if (byte[].class.isAssignableFrom(retType)) {
            return true;
        }
        if (Enum.class.isAssignableFrom(retType)) {
            return true;
        }
        if (ObjectUtils.builtInTypes().contains(retType)) {
            return true;
        }
        for (Class<?> builtInType : ObjectUtils.builtInTypes()) {
            if (!builtInType.isAssignableFrom(retType)) continue;
            return true;
        }
        return false;
    }

    public static List<Class<?>> builtInTypes() {
        return Iterables.listOf(byte[].class, Number.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, BigDecimal.class, BigInteger.class, Boolean.class, Character.class, String.class, Date.class, URL.class, URI.class, Currency.class, Calendar.class, StringBuffer.class, StringBuilder.class, Locale.class, Void.class, UUID.class, Pattern.class);
    }

    public static boolean isCompatibleTypes(Class<?> type1, Class<?> type2) {
        if (type1.equals(type2)) {
            return true;
        }
        if (type1.isAssignableFrom(type2)) {
            return true;
        }
        if (type1.isPrimitive()) {
            Class<?> wrapperType = ObjectUtils.toWrapperType(type1);
            return ObjectUtils.isCompatibleTypes(wrapperType, type2);
        }
        if (type2.isPrimitive()) {
            Class<?> wrapperType = ObjectUtils.toWrapperType(type2);
            return ObjectUtils.isCompatibleTypes(type1, wrapperType);
        }
        return false;
    }

    public static Object[] convertToObjectArray(Object array) {
        Class<?> ofArray = array.getClass().getComponentType();
        if (ofArray.isPrimitive()) {
            ArrayList<Object> ar = new ArrayList<Object>();
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                ar.add(Array.get(array, i));
            }
            return ar.toArray();
        }
        return (Object[])array;
    }

    public static <T extends Comparable<? super T>> int compare(T c1, T c2) {
        if (c1 == c2) {
            return 0;
        }
        if (c1 == null) {
            return -1;
        }
        if (c2 == null) {
            return 1;
        }
        return c1.compareTo(c2);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> T deepCopy(T oldObj) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
            Serializable serializable;
            oos.writeObject(oldObj);
            oos.flush();
            try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));){
                serializable = (Serializable)ois.readObject();
            }
            return (T)serializable;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new NitriteIOException("Error while deep copying object", e);
        }
    }

    private static Class<?> toWrapperType(Class<?> type) {
        Class<?> wrapped = PRIMITIVE_TO_WRAPPER_TYPE.get(type);
        return wrapped == null ? type : wrapped;
    }

    private static <P, F> boolean isSkeletonRequired(Class<P> enclosingType, Class<F> fieldType) {
        String fieldTypePackage = ObjectUtils.getPackageName(fieldType);
        String enclosingTypePackage = ObjectUtils.getPackageName(enclosingType);
        return ObjectUtils.isCompatible(enclosingTypePackage, fieldTypePackage);
    }

    private static boolean isCompatible(String enclosingTypePackage, String fieldTypePackage) {
        if (enclosingTypePackage.contains(fieldTypePackage) && fieldTypePackage.contains(".")) {
            return true;
        }
        int lastDot = fieldTypePackage.lastIndexOf(46);
        if (lastDot == -1) {
            return false;
        }
        return ObjectUtils.isCompatible(enclosingTypePackage, fieldTypePackage.substring(0, lastDot));
    }

    private static <T> String getPackageName(Class<T> clazz) {
        String fqName = clazz.getName();
        int lastDot = fqName.lastIndexOf(46);
        if (lastDot == -1) {
            return "";
        }
        return fqName.substring(0, lastDot);
    }

    public static <T> T defaultValue(Class<T> type) {
        if (type.isPrimitive()) {
            switch (type.getName()) {
                case "boolean": {
                    return (T)Boolean.FALSE;
                }
                case "byte": {
                    return (T)Byte.valueOf((byte)0);
                }
                case "short": {
                    return (T)Short.valueOf((short)0);
                }
                case "int": {
                    return (T)Integer.valueOf(0);
                }
                case "long": {
                    return (T)Long.valueOf(0L);
                }
                case "float": {
                    return (T)Float.valueOf(0.0f);
                }
                case "double": {
                    return (T)Double.valueOf(0.0);
                }
                case "char": {
                    return (T)Character.valueOf('\u0000');
                }
            }
        }
        if (type.isArray()) {
            return null;
        }
        if (type == String.class) {
            return null;
        }
        return null;
    }

    static {
        LinkedHashMap<Class<Object>, Class<Void>> primToWrap = new LinkedHashMap<Class<Object>, Class<Void>>();
        primToWrap.put(Boolean.TYPE, Boolean.class);
        primToWrap.put(Byte.TYPE, Byte.class);
        primToWrap.put(Character.TYPE, Character.class);
        primToWrap.put(Double.TYPE, Double.class);
        primToWrap.put(Float.TYPE, Float.class);
        primToWrap.put(Integer.TYPE, Integer.class);
        primToWrap.put(Long.TYPE, Long.class);
        primToWrap.put(Short.TYPE, Short.class);
        primToWrap.put(Void.TYPE, Void.class);
        PRIMITIVE_TO_WRAPPER_TYPE = Collections.unmodifiableMap(primToWrap);
    }
}

