/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.common.util;

import java.security.SecureRandom;
import java.util.Arrays;

public class SecureString
implements CharSequence {
    private final int[] chars;
    private final int[] pad;

    public SecureString(CharSequence original) {
        this(0, original.length(), original);
    }

    public SecureString(int start, int end, CharSequence original) {
        int length = end - start;
        this.pad = new int[length];
        this.chars = new int[length];
        this.scramble(start, length, original);
    }

    @Override
    public char charAt(int i) {
        return (char)(this.pad[i] ^ this.chars[i]);
    }

    @Override
    public int length() {
        return this.chars.length;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new SecureString(start, end, this);
    }

    public String asString() {
        char[] value = new char[this.chars.length];
        for (int i = 0; i < value.length; ++i) {
            value[i] = this.charAt(i);
        }
        return new String(value);
    }

    public void clear() {
        Arrays.fill(this.chars, 48);
        Arrays.fill(this.pad, 0);
    }

    @Override
    public String toString() {
        return "Secure:XXXXX";
    }

    private void scramble(int start, int length, CharSequence characters) {
        SecureRandom random = new SecureRandom();
        for (int i = start; i < length; ++i) {
            char charAt = characters.charAt(i);
            this.pad[i] = random.nextInt();
            this.chars[i] = this.pad[i] ^ charAt;
        }
    }
}

