/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.filters;

import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.exceptions.FilterException;
import org.dizitart.no2.filters.Filter;
import org.dizitart.no2.filters.LogicalFilter;
import org.dizitart.no2.filters.TextFilter;

public class AndFilter
extends LogicalFilter {
    AndFilter(Filter ... filters) {
        super(filters);
        for (int i = 1; i < filters.length; ++i) {
            if (!(filters[i] instanceof TextFilter)) continue;
            throw new FilterException("Text filter must be the first filter in AND operation");
        }
    }

    @Override
    public boolean apply(Pair<NitriteId, Document> element) {
        for (Filter filter : this.getFilters()) {
            if (filter.apply(element)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        for (int i = 0; i < this.getFilters().size(); ++i) {
            Filter filter = this.getFilters().get(i);
            if (i > 0) {
                stringBuilder.append(" && ");
            }
            stringBuilder.append(filter.toString());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

