/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.filters;

import lombok.Generated;
import org.dizitart.no2.exceptions.FilterException;
import org.dizitart.no2.filters.AndFilter;
import org.dizitart.no2.filters.Filter;
import org.dizitart.no2.filters.GreaterEqualFilter;
import org.dizitart.no2.filters.GreaterThanFilter;
import org.dizitart.no2.filters.LesserEqualFilter;
import org.dizitart.no2.filters.LesserThanFilter;

class BetweenFilter<T>
extends AndFilter {
    public BetweenFilter(String field, Bound<T> bound) {
        super(BetweenFilter.getRhs(field, bound), BetweenFilter.getLhs(field, bound));
    }

    private static <T> Filter getRhs(String field, Bound<T> bound) {
        BetweenFilter.validateBound(bound);
        Object value = bound.upperBound;
        if (bound.upperInclusive) {
            return new LesserEqualFilter(field, (Comparable)value);
        }
        return new LesserThanFilter(field, (Comparable)value);
    }

    private static <T> Filter getLhs(String field, Bound<T> bound) {
        BetweenFilter.validateBound(bound);
        Object value = bound.lowerBound;
        if (bound.lowerInclusive) {
            return new GreaterEqualFilter(field, (Comparable)value);
        }
        return new GreaterThanFilter(field, (Comparable)value);
    }

    private static <T> void validateBound(Bound<T> bound) {
        if (bound == null) {
            throw new FilterException("Bound cannot be null");
        }
        if (!(bound.upperBound instanceof Comparable) || !(bound.lowerBound instanceof Comparable)) {
            throw new FilterException("Upper bound or lower bound value must be comparable");
        }
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public static class Bound<T> {
        private T upperBound;
        private T lowerBound;
        private boolean upperInclusive;
        private boolean lowerInclusive;

        public Bound(T lowerBound, T upperBound) {
            this(lowerBound, upperBound, true);
        }

        public Bound(T lowerBound, T upperBound, boolean inclusive) {
            this(lowerBound, upperBound, inclusive, inclusive);
        }

        public Bound(T lowerBound, T upperBound, boolean lowerInclusive, boolean upperInclusive) {
            this.upperBound = upperBound;
            this.lowerBound = lowerBound;
            this.upperInclusive = upperInclusive;
            this.lowerInclusive = lowerInclusive;
        }

        @Generated
        public T getUpperBound() {
            return this.upperBound;
        }

        @Generated
        public T getLowerBound() {
            return this.lowerBound;
        }

        @Generated
        public boolean isUpperInclusive() {
            return this.upperInclusive;
        }

        @Generated
        public boolean isLowerInclusive() {
            return this.lowerInclusive;
        }

        @Generated
        public void setUpperBound(T upperBound) {
            this.upperBound = upperBound;
        }

        @Generated
        public void setLowerBound(T lowerBound) {
            this.lowerBound = lowerBound;
        }

        @Generated
        public void setUpperInclusive(boolean upperInclusive) {
            this.upperInclusive = upperInclusive;
        }

        @Generated
        public void setLowerInclusive(boolean lowerInclusive) {
            this.lowerInclusive = lowerInclusive;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Bound)) {
                return false;
            }
            Bound other = (Bound)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isUpperInclusive() != other.isUpperInclusive()) {
                return false;
            }
            if (this.isLowerInclusive() != other.isLowerInclusive()) {
                return false;
            }
            T this$upperBound = this.getUpperBound();
            T other$upperBound = other.getUpperBound();
            if (this$upperBound == null ? other$upperBound != null : !this$upperBound.equals(other$upperBound)) {
                return false;
            }
            T this$lowerBound = this.getLowerBound();
            T other$lowerBound = other.getLowerBound();
            return !(this$lowerBound == null ? other$lowerBound != null : !this$lowerBound.equals(other$lowerBound));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Bound;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isUpperInclusive() ? 79 : 97);
            result = result * 59 + (this.isLowerInclusive() ? 79 : 97);
            T $upperBound = this.getUpperBound();
            result = result * 59 + ($upperBound == null ? 43 : $upperBound.hashCode());
            T $lowerBound = this.getLowerBound();
            result = result * 59 + ($lowerBound == null ? 43 : $lowerBound.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BetweenFilter.Bound(upperBound=" + this.getUpperBound() + ", lowerBound=" + this.getLowerBound() + ", upperInclusive=" + this.isUpperInclusive() + ", lowerInclusive=" + this.isLowerInclusive() + ")";
        }
    }
}

