/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.filters;

import org.dizitart.no2.filters.BetweenFilter;
import org.dizitart.no2.filters.ElementMatchFilter;
import org.dizitart.no2.filters.EqualsFilter;
import org.dizitart.no2.filters.Filter;
import org.dizitart.no2.filters.GreaterEqualFilter;
import org.dizitart.no2.filters.GreaterThanFilter;
import org.dizitart.no2.filters.InFilter;
import org.dizitart.no2.filters.LesserEqualFilter;
import org.dizitart.no2.filters.LesserThanFilter;
import org.dizitart.no2.filters.NitriteFilter;
import org.dizitart.no2.filters.NotEqualsFilter;
import org.dizitart.no2.filters.NotInFilter;
import org.dizitart.no2.filters.RegexFilter;
import org.dizitart.no2.filters.TextFilter;

public final class FluentFilter {
    public static FluentFilter $ = FluentFilter.where("$");
    private String field;

    private FluentFilter() {
    }

    public static FluentFilter where(String field) {
        FluentFilter filter = new FluentFilter();
        filter.field = field;
        return filter;
    }

    public NitriteFilter eq(Object value) {
        return new EqualsFilter(this.field, value);
    }

    public NitriteFilter notEq(Object value) {
        return new NotEqualsFilter(this.field, value);
    }

    public NitriteFilter gt(Comparable<?> value) {
        return new GreaterThanFilter(this.field, value);
    }

    public NitriteFilter gte(Comparable<?> value) {
        return new GreaterEqualFilter(this.field, value);
    }

    public NitriteFilter lt(Comparable<?> value) {
        return new LesserThanFilter(this.field, value);
    }

    public NitriteFilter lte(Comparable<?> value) {
        return new LesserEqualFilter(this.field, value);
    }

    public NitriteFilter between(Comparable<?> lowerBound, Comparable<?> upperBound) {
        return new BetweenFilter(this.field, new BetweenFilter.Bound(lowerBound, upperBound));
    }

    public NitriteFilter between(Comparable<?> lowerBound, Comparable<?> upperBound, boolean inclusive) {
        return new BetweenFilter(this.field, new BetweenFilter.Bound(lowerBound, upperBound, inclusive));
    }

    public NitriteFilter between(Comparable<?> lowerBound, Comparable<?> upperBound, boolean lowerInclusive, boolean upperInclusive) {
        return new BetweenFilter(this.field, new BetweenFilter.Bound(lowerBound, upperBound, lowerInclusive, upperInclusive));
    }

    public NitriteFilter text(String value) {
        return new TextFilter(this.field, value);
    }

    public NitriteFilter regex(String value) {
        return new RegexFilter(this.field, value);
    }

    public NitriteFilter in(Comparable<?> ... values) {
        return new InFilter(this.field, values);
    }

    public NitriteFilter notIn(Comparable<?> ... values) {
        return new NotInFilter(this.field, values);
    }

    public NitriteFilter elemMatch(Filter filter) {
        return new ElementMatchFilter(this.field, filter);
    }
}

