/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.migration;

import org.dizitart.no2.common.Fields;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.common.tuples.Triplet;
import org.dizitart.no2.migration.Generator;
import org.dizitart.no2.migration.Instruction;
import org.dizitart.no2.migration.InstructionType;
import org.dizitart.no2.migration.MigrationStep;

public interface CollectionInstruction
extends Instruction {
    default public CollectionInstruction rename(final String name) {
        MigrationStep migrationStep = new MigrationStep();
        migrationStep.setInstructionType(InstructionType.CollectionRename);
        migrationStep.setArguments(new Pair<String, String>(this.collectionName(), name));
        this.addStep(migrationStep);
        final CollectionInstruction parent = this;
        return new CollectionInstruction(){

            @Override
            public String collectionName() {
                return name;
            }

            @Override
            public void addStep(MigrationStep step) {
                parent.addStep(step);
            }
        };
    }

    default public CollectionInstruction addField(String fieldName) {
        return this.addField(fieldName, null);
    }

    default public CollectionInstruction addField(String fieldName, Object defaultValue) {
        MigrationStep migrationStep = new MigrationStep();
        migrationStep.setInstructionType(InstructionType.CollectionAddField);
        migrationStep.setArguments(new Triplet<String, String, Object>(this.collectionName(), fieldName, defaultValue));
        this.addStep(migrationStep);
        return this;
    }

    default public CollectionInstruction addField(String fieldName, Generator<?> generator) {
        MigrationStep migrationStep = new MigrationStep();
        migrationStep.setInstructionType(InstructionType.CollectionAddField);
        migrationStep.setArguments(new Triplet(this.collectionName(), fieldName, generator));
        this.addStep(migrationStep);
        return this;
    }

    default public CollectionInstruction renameField(String oldName, String newName) {
        MigrationStep migrationStep = new MigrationStep();
        migrationStep.setInstructionType(InstructionType.CollectionRenameField);
        migrationStep.setArguments(new Triplet<String, String, String>(this.collectionName(), oldName, newName));
        this.addStep(migrationStep);
        return this;
    }

    default public CollectionInstruction deleteField(String fieldName) {
        MigrationStep migrationStep = new MigrationStep();
        migrationStep.setInstructionType(InstructionType.CollectionDeleteField);
        migrationStep.setArguments(new Pair<String, String>(this.collectionName(), fieldName));
        this.addStep(migrationStep);
        return this;
    }

    default public CollectionInstruction dropIndex(String ... indexedFieldNames) {
        Fields indexedFields = Fields.withNames(indexedFieldNames);
        MigrationStep migrationStep = new MigrationStep();
        migrationStep.setInstructionType(InstructionType.CollectionDropIndex);
        migrationStep.setArguments(new Pair<String, Fields>(this.collectionName(), indexedFields));
        this.addStep(migrationStep);
        return this;
    }

    default public CollectionInstruction dropAllIndices() {
        MigrationStep migrationStep = new MigrationStep();
        migrationStep.setInstructionType(InstructionType.CollectionDropIndices);
        migrationStep.setArguments(this.collectionName());
        this.addStep(migrationStep);
        return this;
    }

    default public CollectionInstruction createIndex(String indexType, String ... fieldNames) {
        Fields indexedFields = Fields.withNames(fieldNames);
        MigrationStep migrationStep = new MigrationStep();
        migrationStep.setInstructionType(InstructionType.CollectionCreateIndex);
        migrationStep.setArguments(new Triplet<String, Fields, String>(this.collectionName(), indexedFields, indexType));
        this.addStep(migrationStep);
        return this;
    }

    public String collectionName();
}

