/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.repository;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.dizitart.no2.collection.NitriteCollection;
import org.dizitart.no2.common.mapper.NitriteMapper;
import org.dizitart.no2.common.util.StringUtils;
import org.dizitart.no2.exceptions.NotIdentifiableException;
import org.dizitart.no2.index.IndexOptions;
import org.dizitart.no2.repository.IndexValidator;
import org.dizitart.no2.repository.ObjectIdField;
import org.dizitart.no2.repository.Reflector;
import org.dizitart.no2.repository.annotations.Entity;
import org.dizitart.no2.repository.annotations.Id;
import org.dizitart.no2.repository.annotations.Index;
import org.dizitart.no2.repository.annotations.Indices;
import org.dizitart.no2.repository.annotations.InheritIndices;

class AnnotationScanner {
    private final Set<Index> indices;
    private final Class<?> type;
    private final NitriteMapper nitriteMapper;
    private final Reflector reflector;
    private final NitriteCollection collection;
    private final IndexValidator indexValidator;
    private ObjectIdField objectIdField;

    public AnnotationScanner(Class<?> type, NitriteCollection collection, NitriteMapper nitriteMapper) {
        this.type = type;
        this.nitriteMapper = nitriteMapper;
        this.collection = collection;
        this.reflector = new Reflector();
        this.indices = new HashSet<Index>();
        this.indexValidator = new IndexValidator();
    }

    public void createIndices() {
        for (Index index : this.indices) {
            String[] fields = index.fields();
            this.collection.createIndex(IndexOptions.indexOptions(index.type()), fields);
        }
    }

    public void createIdIndex() {
        if (this.objectIdField != null) {
            String[] fieldNames = this.objectIdField.getEmbeddedFieldNames();
            this.collection.createIndex(fieldNames);
        }
    }

    public void performScan() {
        this.scanIndicesAnnotation();
        this.scanIndexAnnotation();
        this.scanEntityAnnotation();
        this.scanIdAnnotation();
    }

    private void scanIndicesAnnotation() {
        List<Object> indicesList;
        if (this.type.isAnnotationPresent(InheritIndices.class)) {
            indicesList = this.reflector.findInheritedAnnotations(Indices.class, this.type);
        } else {
            indicesList = new ArrayList();
            Indices indices = this.type.getAnnotation(Indices.class);
            if (indices != null) {
                indicesList.add(indices);
            }
        }
        for (Indices indices : indicesList) {
            Index[] indexList = indices.value();
            this.populateIndex(Arrays.asList(indexList));
        }
    }

    private void scanIndexAnnotation() {
        ArrayList<Index> indexList;
        if (this.type.isAnnotationPresent(InheritIndices.class)) {
            indexList = this.reflector.findInheritedAnnotations(Index.class, this.type);
        } else {
            indexList = new ArrayList();
            Index index = this.type.getAnnotation(Index.class);
            if (index != null) {
                indexList.add(index);
            }
        }
        this.populateIndex(indexList);
    }

    private void scanEntityAnnotation() {
        ArrayList<Index> indexList = new ArrayList<Index>();
        if (this.type.isAnnotationPresent(InheritIndices.class)) {
            List<Entity> entities = this.reflector.findInheritedAnnotations(Entity.class, this.type);
            if (!entities.isEmpty()) {
                for (Entity entity : entities) {
                    indexList.addAll(Arrays.asList(entity.indices()));
                }
            }
        } else if (this.type.isAnnotationPresent(Entity.class)) {
            Entity entity = this.type.getAnnotation(Entity.class);
            indexList.addAll(Arrays.asList(entity.indices()));
        }
        this.populateIndex(indexList);
    }

    private void scanIdAnnotation() {
        List<Field> fieldList = this.reflector.getAllFields(this.type);
        boolean alreadyIdFound = false;
        for (Field field : fieldList) {
            if (!field.isAnnotationPresent(Id.class)) continue;
            Id id = field.getAnnotation(Id.class);
            String fieldName = StringUtils.isNullOrEmpty(id.fieldName()) ? field.getName() : id.fieldName();
            this.indexValidator.validateId(id, field.getType(), fieldName, this.nitriteMapper);
            if (alreadyIdFound) {
                throw new NotIdentifiableException("Multiple id fields found for the type");
            }
            alreadyIdFound = true;
            this.objectIdField = new ObjectIdField();
            this.objectIdField.setField(field);
            this.objectIdField.setIdFieldName(fieldName);
            this.objectIdField.setEmbedded(id.embeddedFields().length > 0);
            this.objectIdField.setFieldNames(id.embeddedFields());
        }
    }

    private void populateIndex(List<Index> indexList) {
        for (Index index : indexList) {
            String[] names = index.fields();
            ArrayList<Field> entityFields = new ArrayList<Field>();
            for (String name : names) {
                Field field = this.reflector.getField(this.type, name);
                if (field == null) continue;
                entityFields.add(field);
                this.indexValidator.validate(field.getType(), field.getName(), this.nitriteMapper);
            }
            if (entityFields.size() != names.length) continue;
            this.indices.add(index);
        }
    }

    @Generated
    public ObjectIdField getObjectIdField() {
        return this.objectIdField;
    }
}

