/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.repository;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.dizitart.no2.NitriteConfig;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.common.mapper.NitriteMapper;
import org.dizitart.no2.exceptions.ObjectMappingException;
import org.dizitart.no2.filters.Filter;
import org.dizitart.no2.filters.FluentFilter;
import org.dizitart.no2.filters.NitriteFilter;

public class EntityId {
    private final String fieldName;
    private final String[] embeddedFields;
    private List<String> encodedFieldNames;

    public EntityId(String fieldName, String ... subFields) {
        this.fieldName = fieldName;
        this.embeddedFields = subFields;
    }

    public List<String> getEncodedFieldNames() {
        if (this.encodedFieldNames != null) {
            return this.encodedFieldNames;
        }
        this.encodedFieldNames = new ArrayList<String>();
        if (this.embeddedFields != null) {
            for (String subField : this.embeddedFields) {
                this.encodedFieldNames.add(this.fieldName + NitriteConfig.getFieldSeparator() + subField);
            }
        }
        return this.encodedFieldNames;
    }

    public boolean isEmbedded() {
        return this.embeddedFields != null && this.embeddedFields.length != 0;
    }

    public Filter createUniqueFilter(Object value, NitriteMapper nitriteMapper) {
        if (this.isEmbedded()) {
            Document document = (Document)nitriteMapper.tryConvert(value, Document.class);
            if (document == null) {
                throw new ObjectMappingException("Failed to map object to document");
            }
            ArrayList<NitriteFilter> filters = new ArrayList<NitriteFilter>();
            for (String subField : this.embeddedFields) {
                String filterField = this.fieldName + NitriteConfig.getFieldSeparator() + subField;
                Object fieldValue = document.get(subField);
                filters.add(FluentFilter.where(filterField).eq(fieldValue));
            }
            NitriteFilter nitriteFilter = (NitriteFilter)Filter.and(filters.toArray(new Filter[0]));
            nitriteFilter.setObjectFilter(true);
            return nitriteFilter;
        }
        return FluentFilter.where(this.fieldName).eq(value);
    }

    @Generated
    public String getFieldName() {
        return this.fieldName;
    }

    @Generated
    public String[] getEmbeddedFields() {
        return this.embeddedFields;
    }
}

