/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.repository;

import java.lang.reflect.Modifier;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.mapper.NitriteMapper;
import org.dizitart.no2.common.util.ObjectUtils;
import org.dizitart.no2.exceptions.IndexingException;
import org.dizitart.no2.repository.EntityId;
import org.dizitart.no2.repository.annotations.Id;

public class IndexValidator {
    public void validate(Class<?> fieldType, String field, NitriteMapper nitriteMapper) {
        if (fieldType.isPrimitive() || fieldType == NitriteId.class || fieldType.isInterface() || Modifier.isAbstract(fieldType.getModifiers()) || fieldType.isArray() || Iterable.class.isAssignableFrom(fieldType)) {
            return;
        }
        if (!Comparable.class.isAssignableFrom(fieldType)) {
            throw new IndexingException("Cannot create index on non comparable field " + field);
        }
    }

    public void validateId(Id id, Class<?> fieldType, String field, NitriteMapper nitriteMapper) {
        if (fieldType.isPrimitive() || fieldType == NitriteId.class) {
            return;
        }
        Object dummyValue = ObjectUtils.newInstance(fieldType, true, nitriteMapper);
        Document dummyDocument = (Document)nitriteMapper.tryConvert(dummyValue, Document.class);
        if (dummyDocument != null && dummyDocument.size() != 0 && id.embeddedFields().length == 0) {
            throw new IndexingException("Invalid Id field " + field);
        }
    }

    public void validateId(EntityId entityId, Class<?> fieldType, String field, NitriteMapper nitriteMapper) {
        if (fieldType.isPrimitive() || fieldType == NitriteId.class) {
            return;
        }
        Object dummyValue = ObjectUtils.newInstance(fieldType, true, nitriteMapper);
        Document dummyDocument = (Document)nitriteMapper.tryConvert(dummyValue, Document.class);
        if (dummyDocument != null && dummyDocument.size() != 0 && entityId.getEncodedFieldNames().isEmpty()) {
            throw new IndexingException("Invalid Id field " + field);
        }
    }
}

