/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.repository;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.DocumentCursor;
import org.dizitart.no2.collection.FindPlan;
import org.dizitart.no2.common.Lookup;
import org.dizitart.no2.common.RecordStream;
import org.dizitart.no2.common.mapper.NitriteMapper;
import org.dizitart.no2.common.streams.MutatedObjectStream;
import org.dizitart.no2.common.util.DocumentUtils;
import org.dizitart.no2.common.util.ValidationUtils;
import org.dizitart.no2.exceptions.InvalidOperationException;
import org.dizitart.no2.exceptions.ValidationException;
import org.dizitart.no2.repository.Cursor;

class ObjectCursor<T>
implements Cursor<T> {
    private final DocumentCursor cursor;
    private final NitriteMapper nitriteMapper;
    private final Class<T> type;

    public ObjectCursor(NitriteMapper nitriteMapper, DocumentCursor cursor, Class<T> type) {
        this.nitriteMapper = nitriteMapper;
        this.cursor = cursor;
        this.type = type;
    }

    @Override
    public long size() {
        return this.cursor.size();
    }

    @Override
    public FindPlan getFindPlan() {
        return this.cursor.getFindPlan();
    }

    @Override
    public <P> RecordStream<P> project(Class<P> projectionType) {
        ValidationUtils.notNull(projectionType, "projection cannot be null");
        Document dummyDoc = this.emptyDocument(this.nitriteMapper, projectionType);
        return new MutatedObjectStream<P>(this.nitriteMapper, this.cursor.project(dummyDoc), projectionType);
    }

    @Override
    public <Foreign, Joined> RecordStream<Joined> join(Cursor<Foreign> foreignCursor, Lookup lookup, Class<Joined> type) {
        ObjectCursor foreignObjectCursor = (ObjectCursor)foreignCursor;
        return new MutatedObjectStream<Joined>(this.nitriteMapper, this.cursor.join(foreignObjectCursor.cursor, lookup), type);
    }

    @Override
    public Iterator<T> iterator() {
        return new ObjectCursorIterator(this.cursor.iterator());
    }

    private <D> Document emptyDocument(NitriteMapper nitriteMapper, Class<D> type) {
        if (type.isPrimitive()) {
            throw new ValidationException("Cannot project to primitive type");
        }
        if (type.isInterface()) {
            throw new ValidationException("Cannot project to interface");
        }
        if (type.isArray()) {
            throw new ValidationException("Cannot project to array");
        }
        if (Modifier.isAbstract(type.getModifiers())) {
            throw new ValidationException("Cannot project to abstract type");
        }
        ValidationUtils.validateProjectionType(type, nitriteMapper);
        Document dummyDoc = DocumentUtils.skeletonDocument(nitriteMapper, type);
        if (dummyDoc == null || dummyDoc.size() == 0) {
            throw new ValidationException("Cannot project to empty type");
        }
        return dummyDoc;
    }

    private class ObjectCursorIterator
    implements Iterator<T> {
        private final Iterator<Document> documentIterator;

        ObjectCursorIterator(Iterator<Document> documentIterator) {
            this.documentIterator = documentIterator;
        }

        @Override
        public boolean hasNext() {
            return this.documentIterator.hasNext();
        }

        @Override
        public T next() {
            Document document = this.documentIterator.next();
            return ObjectCursor.this.nitriteMapper.tryConvert(document, ObjectCursor.this.type);
        }

        @Override
        public void remove() {
            throw new InvalidOperationException("Remove on a cursor is not supported");
        }
    }
}

