/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.collection;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.locks.Lock;
import org.dizitart.no2.NitriteConfig;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.DocumentCursor;
import org.dizitart.no2.collection.FindOptions;
import org.dizitart.no2.collection.NitriteCollection;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.collection.UpdateOptions;
import org.dizitart.no2.collection.events.CollectionEventInfo;
import org.dizitart.no2.collection.events.CollectionEventListener;
import org.dizitart.no2.collection.operation.CollectionOperations;
import org.dizitart.no2.common.Fields;
import org.dizitart.no2.common.WriteResult;
import org.dizitart.no2.common.concurrent.LockService;
import org.dizitart.no2.common.event.EventBus;
import org.dizitart.no2.common.event.NitriteEventBus;
import org.dizitart.no2.common.meta.Attributes;
import org.dizitart.no2.common.processors.Processor;
import org.dizitart.no2.common.util.DocumentUtils;
import org.dizitart.no2.common.util.ValidationUtils;
import org.dizitart.no2.exceptions.IndexingException;
import org.dizitart.no2.exceptions.InvalidOperationException;
import org.dizitart.no2.exceptions.NitriteIOException;
import org.dizitart.no2.exceptions.NotIdentifiableException;
import org.dizitart.no2.filters.Filter;
import org.dizitart.no2.index.IndexDescriptor;
import org.dizitart.no2.index.IndexOptions;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.store.NitriteStore;

class DefaultNitriteCollection
implements NitriteCollection {
    private final String collectionName;
    private final LockService lockService;
    protected NitriteMap<NitriteId, Document> nitriteMap;
    protected NitriteConfig nitriteConfig;
    protected NitriteStore<?> nitriteStore;
    private Lock writeLock;
    private Lock readLock;
    private CollectionOperations collectionOperations;
    private EventBus<CollectionEventInfo<?>, CollectionEventListener> eventBus;
    private volatile boolean isDropped;

    DefaultNitriteCollection(String name, NitriteMap<NitriteId, Document> nitriteMap, NitriteConfig nitriteConfig, LockService lockService) {
        this.collectionName = name;
        this.nitriteConfig = nitriteConfig;
        this.nitriteMap = nitriteMap;
        this.lockService = lockService;
        this.initialize();
    }

    @Override
    public void addProcessor(Processor processor) {
        ValidationUtils.notNull(processor, "a null processor cannot be added");
        try {
            this.writeLock.lock();
            this.checkOpened();
            this.collectionOperations.addProcessor(processor);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public WriteResult insert(Document[] documents) {
        ValidationUtils.notNull(documents, "a null document cannot be inserted");
        ValidationUtils.containsNull(documents, "a null document cannot be inserted");
        try {
            this.writeLock.lock();
            this.checkOpened();
            WriteResult writeResult = this.collectionOperations.insert(documents);
            return writeResult;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public WriteResult update(Document document, boolean insertIfAbsent) {
        ValidationUtils.notNull(document, "a null document cannot be used for update");
        if (insertIfAbsent) {
            return this.update(DocumentUtils.createUniqueFilter(document), document, UpdateOptions.updateOptions(true));
        }
        if (document.hasId()) {
            return this.update(DocumentUtils.createUniqueFilter(document), document, UpdateOptions.updateOptions(false));
        }
        throw new NotIdentifiableException("Update operation failed as the document does not have id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WriteResult update(Filter filter, Document update, UpdateOptions updateOptions) {
        ValidationUtils.notNull(update, "a null document cannot be used for update");
        ValidationUtils.notNull(updateOptions, "updateOptions cannot be null");
        try {
            this.writeLock.lock();
            this.checkOpened();
            WriteResult writeResult = this.collectionOperations.update(filter, update, updateOptions);
            return writeResult;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public WriteResult remove(Document document) {
        ValidationUtils.notNull(document, "a null document cannot be removed");
        if (document.hasId()) {
            try {
                this.writeLock.lock();
                this.checkOpened();
                WriteResult writeResult = this.collectionOperations.remove(document);
                return writeResult;
            }
            finally {
                this.writeLock.unlock();
            }
        }
        throw new NotIdentifiableException("Document has no id, cannot remove by document");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WriteResult remove(Filter filter, boolean justOne) {
        if ((filter == null || filter == Filter.ALL) && justOne) {
            throw new InvalidOperationException("Cannot remove all documents with justOne set to true");
        }
        try {
            this.writeLock.lock();
            this.checkOpened();
            WriteResult writeResult = this.collectionOperations.remove(filter, justOne);
            return writeResult;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void clear() {
        try {
            this.writeLock.lock();
            this.checkOpened();
            this.collectionOperations.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentCursor find(Filter filter, FindOptions findOptions) {
        try {
            this.readLock.lock();
            this.checkOpened();
            DocumentCursor documentCursor = this.collectionOperations.find(filter, findOptions);
            return documentCursor;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createIndex(IndexOptions indexOptions, String ... fields) {
        ValidationUtils.notNull(fields, "fields cannot be null");
        Fields indexFields = Fields.withNames(fields);
        try {
            this.writeLock.lock();
            this.checkOpened();
            if (indexOptions == null) {
                this.collectionOperations.createIndex(indexFields, "Unique");
            } else {
                this.collectionOperations.createIndex(indexFields, indexOptions.getIndexType());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebuildIndex(String ... fields) {
        IndexDescriptor indexDescriptor;
        ValidationUtils.notNull(fields, "fields cannot be null");
        Fields indexFields = Fields.withNames(fields);
        try {
            this.readLock.lock();
            this.checkOpened();
            indexDescriptor = this.collectionOperations.findIndex(indexFields);
        }
        finally {
            this.readLock.unlock();
        }
        if (indexDescriptor != null) {
            this.validateRebuildIndex(indexDescriptor);
            try {
                this.writeLock.lock();
                this.checkOpened();
                this.collectionOperations.rebuildIndex(indexDescriptor);
            }
            finally {
                this.writeLock.unlock();
            }
        } else {
            throw new IndexingException(Arrays.toString(fields) + " is not indexed");
        }
    }

    @Override
    public Collection<IndexDescriptor> listIndices() {
        try {
            this.readLock.lock();
            this.checkOpened();
            Collection<IndexDescriptor> collection = this.collectionOperations.listIndexes();
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasIndex(String ... fields) {
        ValidationUtils.notNull(fields, "fields cannot be null");
        Fields indexFields = Fields.withNames(fields);
        try {
            this.readLock.lock();
            this.checkOpened();
            boolean bl = this.collectionOperations.hasIndex(indexFields);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isIndexing(String ... fields) {
        ValidationUtils.notNull(fields, "field cannot be null");
        Fields indexFields = Fields.withNames(fields);
        try {
            this.readLock.lock();
            this.checkOpened();
            boolean bl = this.collectionOperations.isIndexing(indexFields);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void dropIndex(String ... fields) {
        ValidationUtils.notNull(fields, "fields cannot be null");
        Fields indexFields = Fields.withNames(fields);
        try {
            this.writeLock.lock();
            this.checkOpened();
            this.collectionOperations.dropIndex(indexFields);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void dropAllIndices() {
        try {
            this.writeLock.lock();
            this.checkOpened();
            this.collectionOperations.dropAllIndices();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Document getById(NitriteId nitriteId) {
        ValidationUtils.notNull(nitriteId, "nitriteId cannot be null");
        try {
            this.readLock.lock();
            this.checkOpened();
            Document document = this.collectionOperations.getById(nitriteId);
            return document;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void drop() {
        try {
            this.writeLock.lock();
            this.checkOpened();
            if (this.collectionOperations != null) {
                this.collectionOperations.dropCollection();
            }
            this.nitriteMap = null;
            this.nitriteConfig = null;
            this.collectionOperations = null;
            this.nitriteStore = null;
            this.closeEventBus();
        }
        finally {
            this.writeLock.unlock();
        }
        this.isDropped = true;
    }

    @Override
    public boolean isDropped() {
        try {
            this.readLock.lock();
            boolean bl = this.isDropped || this.nitriteMap == null || this.nitriteMap.isDropped();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isOpen() {
        try {
            this.readLock.lock();
            boolean bl = this.nitriteStore != null && !this.nitriteStore.isClosed() && !this.isDropped && !this.nitriteMap.isClosed() && !this.nitriteMap.isDropped();
            return bl;
        }
        catch (Exception e) {
            throw new NitriteIOException("Failed to check the collection state", e);
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void close() {
        try {
            this.writeLock.lock();
            if (this.collectionOperations != null) {
                this.collectionOperations.close();
            }
            this.nitriteMap = null;
            this.nitriteConfig = null;
            this.collectionOperations = null;
            this.nitriteStore = null;
            this.closeEventBus();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public String getName() {
        return this.collectionName;
    }

    @Override
    public long size() {
        try {
            this.readLock.lock();
            this.checkOpened();
            long l = this.collectionOperations.getSize();
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public NitriteStore<?> getStore() {
        try {
            this.writeLock.lock();
            NitriteStore<?> nitriteStore = this.nitriteStore;
            return nitriteStore;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void subscribe(CollectionEventListener listener) {
        ValidationUtils.notNull(listener, "listener cannot be null");
        try {
            this.writeLock.lock();
            this.checkOpened();
            this.eventBus.register(listener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void unsubscribe(CollectionEventListener listener) {
        ValidationUtils.notNull(listener, "listener cannot be null");
        try {
            this.writeLock.lock();
            this.checkOpened();
            if (this.eventBus != null) {
                this.eventBus.deregister(listener);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Attributes getAttributes() {
        try {
            this.readLock.lock();
            this.checkOpened();
            Attributes attributes = this.collectionOperations.getAttributes();
            return attributes;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setAttributes(Attributes attributes) {
        ValidationUtils.notNull(attributes, "attributes cannot be null");
        try {
            this.writeLock.lock();
            this.checkOpened();
            this.collectionOperations.setAttributes(attributes);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void closeEventBus() {
        if (this.eventBus != null) {
            this.eventBus.close();
        }
        this.eventBus = null;
    }

    private void initialize() {
        this.isDropped = false;
        this.readLock = this.lockService.getReadLock(this.collectionName);
        this.writeLock = this.lockService.getWriteLock(this.collectionName);
        this.nitriteStore = this.nitriteConfig.getNitriteStore();
        this.eventBus = new CollectionEventBus();
        this.collectionOperations = new CollectionOperations(this.collectionName, this.nitriteMap, this.nitriteConfig, this.eventBus);
    }

    private void checkOpened() {
        if (this.isOpen()) {
            return;
        }
        throw new NitriteIOException("Collection is closed");
    }

    private void validateRebuildIndex(IndexDescriptor indexDescriptor) {
        ValidationUtils.notNull(indexDescriptor, "index cannot be null");
        String[] indexFields = indexDescriptor.getFields().getFieldNames().toArray(new String[0]);
        if (this.isIndexing(indexFields)) {
            throw new IndexingException("Cannot rebuild index, index is currently being built");
        }
    }

    private static class CollectionEventBus
    extends NitriteEventBus<CollectionEventInfo<?>, CollectionEventListener> {
        private CollectionEventBus() {
        }

        @Override
        public void post(CollectionEventInfo<?> collectionEventInfo) {
            for (CollectionEventListener listener : this.getListeners()) {
                this.getEventExecutor().submit(() -> listener.onEvent(collectionEventInfo));
            }
        }
    }
}

