/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.collection.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.dizitart.no2.NitriteConfig;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.collection.events.CollectionEventInfo;
import org.dizitart.no2.collection.events.CollectionEventListener;
import org.dizitart.no2.collection.events.EventType;
import org.dizitart.no2.collection.operation.IndexManager;
import org.dizitart.no2.common.FieldValues;
import org.dizitart.no2.common.Fields;
import org.dizitart.no2.common.concurrent.ThreadPoolManager;
import org.dizitart.no2.common.event.EventBus;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.common.util.DocumentUtils;
import org.dizitart.no2.exceptions.IndexingException;
import org.dizitart.no2.index.IndexDescriptor;
import org.dizitart.no2.index.NitriteIndexer;
import org.dizitart.no2.store.NitriteMap;

class IndexOperations
implements AutoCloseable {
    private final String collectionName;
    private final NitriteConfig nitriteConfig;
    private final NitriteMap<NitriteId, Document> nitriteMap;
    private final EventBus<CollectionEventInfo<?>, CollectionEventListener> eventBus;
    private final Map<Fields, AtomicBoolean> indexBuildTracker;
    private IndexManager indexManager;

    IndexOperations(String collectionName, NitriteConfig nitriteConfig, NitriteMap<NitriteId, Document> nitriteMap, EventBus<CollectionEventInfo<?>, CollectionEventListener> eventBus) {
        this.collectionName = collectionName;
        this.nitriteConfig = nitriteConfig;
        this.nitriteMap = nitriteMap;
        this.eventBus = eventBus;
        this.indexBuildTracker = new ConcurrentHashMap<Fields, AtomicBoolean>();
        this.indexManager = new IndexManager(collectionName, nitriteConfig);
    }

    @Override
    public void close() {
        this.indexManager.close();
    }

    void createIndex(Fields fields, String indexType) {
        IndexDescriptor indexDescriptor = this.indexManager.findExactIndexDescriptor(fields);
        if (indexDescriptor != null) {
            if (!indexDescriptor.getIndexType().equals(indexType)) {
                throw new IndexingException("Index already exists on fields: " + fields + " with type " + indexDescriptor.getIndexType());
            }
            return;
        }
        indexDescriptor = this.indexManager.createIndexDescriptor(fields, indexType);
        this.buildIndex(indexDescriptor, false);
    }

    void buildIndex(IndexDescriptor indexDescriptor, boolean rebuild) {
        Fields fields = indexDescriptor.getFields();
        if (this.getBuildFlag(fields).compareAndSet(false, true)) {
            this.buildIndexInternal(indexDescriptor, rebuild);
            return;
        }
        throw new IndexingException("Index build already in progress on fields: " + indexDescriptor.getFields());
    }

    void dropIndex(Fields fields) {
        if (this.getBuildFlag(fields).get()) {
            throw new IndexingException("Index build already in progress on fields: " + fields);
        }
        IndexDescriptor indexDescriptor = this.findIndexDescriptor(fields);
        if (indexDescriptor == null) {
            throw new IndexingException("Index does not exist on fields: " + fields);
        }
        String indexType = indexDescriptor.getIndexType();
        NitriteIndexer nitriteIndexer = this.nitriteConfig.findIndexer(indexType);
        nitriteIndexer.dropIndex(indexDescriptor, this.nitriteConfig);
        this.indexManager.dropIndexDescriptor(fields);
        this.indexBuildTracker.remove(fields);
    }

    void dropAllIndices() {
        for (Map.Entry<Fields, AtomicBoolean> entry : this.indexBuildTracker.entrySet()) {
            if (entry.getValue() == null || !entry.getValue().get()) continue;
            throw new IndexingException("Index build already in progress on fields: " + entry.getKey());
        }
        ArrayList futures = new ArrayList();
        for (IndexDescriptor indexDescriptor : this.listIndexes()) {
            futures.add(ThreadPoolManager.runAsync(() -> this.dropIndex(index.getFields())));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IndexingException("Failed to drop all indices", e);
            }
        }
        this.indexManager.dropIndexMeta();
        this.indexBuildTracker.clear();
        this.indexManager.close();
        this.indexManager = new IndexManager(this.collectionName, this.nitriteConfig);
    }

    void clear() {
        for (Map.Entry<Fields, AtomicBoolean> entry : this.indexBuildTracker.entrySet()) {
            if (entry.getValue() == null || !entry.getValue().get()) continue;
            throw new IndexingException("Index build already in progress on fields: " + entry.getKey());
        }
        this.indexManager.clearAll();
        this.indexBuildTracker.clear();
    }

    boolean isIndexing(Fields field) {
        return this.indexManager.hasIndexDescriptor(field) && this.getBuildFlag(field).get();
    }

    boolean hasIndexEntry(Fields field) {
        return this.indexManager.hasIndexDescriptor(field);
    }

    Collection<IndexDescriptor> listIndexes() {
        return this.indexManager.getIndexDescriptors();
    }

    IndexDescriptor findIndexDescriptor(Fields field) {
        return this.indexManager.findExactIndexDescriptor(field);
    }

    boolean shouldRebuildIndex(Fields fields) {
        return this.indexManager.isDirtyIndex(fields) && !this.getBuildFlag(fields).get();
    }

    private AtomicBoolean getBuildFlag(Fields field) {
        AtomicBoolean flag = this.indexBuildTracker.get(field);
        if (flag != null) {
            return flag;
        }
        flag = new AtomicBoolean(false);
        this.indexBuildTracker.put(field, flag);
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildIndexInternal(IndexDescriptor indexDescriptor, boolean rebuild) {
        Fields fields = indexDescriptor.getFields();
        try {
            this.alert(EventType.IndexStart, fields);
            this.indexManager.beginIndexing(fields);
            String indexType = indexDescriptor.getIndexType();
            NitriteIndexer nitriteIndexer = this.nitriteConfig.findIndexer(indexType);
            if (rebuild) {
                nitriteIndexer.dropIndex(indexDescriptor, this.nitriteConfig);
            }
            for (Pair pair : this.nitriteMap.entries()) {
                Document document = (Document)pair.getSecond();
                FieldValues fieldValues = DocumentUtils.getValues(document, indexDescriptor.getFields());
                nitriteIndexer.writeIndexEntry(fieldValues, indexDescriptor, this.nitriteConfig);
            }
        }
        finally {
            this.indexManager.endIndexing(fields);
            this.getBuildFlag(fields).set(false);
            this.alert(EventType.IndexEnd, fields);
        }
    }

    private void alert(EventType eventType, Fields field) {
        CollectionEventInfo<Fields> eventInfo = new CollectionEventInfo<Fields>();
        eventInfo.setItem(field);
        eventInfo.setTimestamp(System.currentTimeMillis());
        eventInfo.setEventType(eventType);
        if (this.eventBus != null) {
            this.eventBus.post(eventInfo);
        }
    }
}

