/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.common.concurrent;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.dizitart.no2.common.concurrent.ErrorAwareThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"nitrite");
    private static final List<ExecutorService> threadPools = new CopyOnWriteArrayList<ExecutorService>();
    private static final ExecutorService commonPool = ThreadPoolManager.workerPool();
    private static final Object lock;

    public static ExecutorService workerPool() {
        return ThreadPoolManager.getThreadPool(Runtime.getRuntime().availableProcessors(), "Worker.NO\u2082");
    }

    public static ExecutorService getThreadPool(int size, String threadName) {
        ExecutorService threadPool = Executors.newFixedThreadPool(size, ThreadPoolManager.threadFactory(threadName));
        threadPools.add(threadPool);
        return threadPool;
    }

    public static ScheduledExecutorService getScheduledThreadPool(int size, String threadName) {
        ScheduledExecutorService threadPool = Executors.newScheduledThreadPool(size, ThreadPoolManager.threadFactory(threadName));
        threadPools.add(threadPool);
        return threadPool;
    }

    public static ErrorAwareThreadFactory threadFactory(final String name) {
        return new ErrorAwareThreadFactory(){

            @Override
            public Thread createThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setName(name);
                thread.setDaemon(true);
                return thread;
            }
        };
    }

    public static Future<?> runAsync(Runnable runnable) {
        return commonPool.submit(runnable);
    }

    public static synchronized void shutdownAllThreadPools() {
        for (ExecutorService threadPool : threadPools) {
            ThreadPoolManager.shutdownThreadPool(threadPool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void shutdownThreadPool(ExecutorService threadPool) {
        block13: {
            Object object = lock;
            synchronized (object) {
                if (threadPool != null) {
                    threadPool.shutdown();
                }
            }
            try {
                if (threadPool == null || threadPool.awaitTermination(10L, TimeUnit.SECONDS)) break block13;
                object = lock;
                synchronized (object) {
                    threadPool.shutdownNow();
                }
                if (!threadPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                    log.error("Thread pool did not terminate");
                }
            }
            catch (InterruptedException e) {
                Object object2 = lock;
                synchronized (object2) {
                    threadPool.shutdownNow();
                }
                Thread.currentThread().interrupt();
            }
        }
        threadPools.remove(threadPool);
    }

    static {
        threadPools.add(commonPool);
        lock = new Object();
    }
}

