/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.index;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dizitart.no2.NitriteConfig;
import org.dizitart.no2.collection.FindPlan;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.FieldValues;
import org.dizitart.no2.common.Fields;
import org.dizitart.no2.exceptions.IndexingException;
import org.dizitart.no2.index.CompoundIndex;
import org.dizitart.no2.index.IndexDescriptor;
import org.dizitart.no2.index.NitriteIndex;
import org.dizitart.no2.index.NitriteIndexer;
import org.dizitart.no2.index.SingleFieldIndex;

public abstract class ComparableIndexer
implements NitriteIndexer {
    private final Map<IndexDescriptor, NitriteIndex> indexRegistry = new ConcurrentHashMap<IndexDescriptor, NitriteIndex>();

    abstract boolean isUnique();

    @Override
    public void initialize(NitriteConfig nitriteConfig) {
    }

    @Override
    public void validateIndex(Fields fields) {
    }

    @Override
    public LinkedHashSet<NitriteId> findByFilter(FindPlan findPlan, NitriteConfig nitriteConfig) {
        NitriteIndex nitriteIndex = this.findNitriteIndex(findPlan.getIndexDescriptor(), nitriteConfig);
        return nitriteIndex.findNitriteIds(findPlan);
    }

    @Override
    public void writeIndexEntry(FieldValues fieldValues, IndexDescriptor indexDescriptor, NitriteConfig nitriteConfig) {
        NitriteIndex nitriteIndex = this.findNitriteIndex(indexDescriptor, nitriteConfig);
        nitriteIndex.write(fieldValues);
    }

    @Override
    public void removeIndexEntry(FieldValues fieldValues, IndexDescriptor indexDescriptor, NitriteConfig nitriteConfig) {
        NitriteIndex nitriteIndex = this.findNitriteIndex(indexDescriptor, nitriteConfig);
        nitriteIndex.remove(fieldValues);
    }

    @Override
    public void dropIndex(IndexDescriptor indexDescriptor, NitriteConfig nitriteConfig) {
        NitriteIndex nitriteIndex = this.findNitriteIndex(indexDescriptor, nitriteConfig);
        nitriteIndex.drop();
    }

    private NitriteIndex findNitriteIndex(IndexDescriptor indexDescriptor, NitriteConfig nitriteConfig) {
        if (indexDescriptor == null) {
            throw new IndexingException("Index descriptor cannot be null");
        }
        if (this.indexRegistry.containsKey(indexDescriptor)) {
            return this.indexRegistry.get(indexDescriptor);
        }
        NitriteIndex nitriteIndex = indexDescriptor.isCompoundIndex() ? new CompoundIndex(indexDescriptor, nitriteConfig.getNitriteStore()) : new SingleFieldIndex(indexDescriptor, nitriteConfig.getNitriteStore());
        this.indexRegistry.put(indexDescriptor, nitriteIndex);
        return nitriteIndex;
    }
}

