/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.index;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.exceptions.FilterException;
import org.dizitart.no2.filters.ComparableFilter;
import org.dizitart.no2.filters.SortingAwareFilter;
import org.dizitart.no2.index.IndexMap;

public class IndexScanner {
    private final IndexMap indexMap;

    public IndexScanner(IndexMap indexMap) {
        this.indexMap = indexMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LinkedHashSet<NitriteId> doScan(List<ComparableFilter> filters, Map<String, Boolean> indexScanOrder) {
        LinkedHashSet<NitriteId> nitriteIds = new LinkedHashSet<NitriteId>();
        if (filters != null && !filters.isEmpty()) {
            List<?> scanResult;
            ComparableFilter comparableFilter = filters.get(0);
            if (comparableFilter == null) throw new FilterException("Index scan is not supported for non comparable filter");
            boolean reverseScan = indexScanOrder != null && indexScanOrder.containsKey(comparableFilter.getField()) ? indexScanOrder.get(comparableFilter.getField()) : false;
            this.indexMap.setReverseScan(reverseScan);
            if (comparableFilter instanceof SortingAwareFilter) {
                ((SortingAwareFilter)comparableFilter).setReverseScan(reverseScan);
            }
            if (this.isEmptyList(scanResult = comparableFilter.applyOnIndex(this.indexMap))) {
                return nitriteIds;
            }
            if (this.isNitriteIdList(scanResult)) {
                List<?> idList = scanResult;
                nitriteIds.addAll(idList);
                return nitriteIds;
            } else {
                if (!this.isNavigableMapList(scanResult)) return nitriteIds;
                List<?> subMaps = scanResult;
                List<ComparableFilter> remainingFilter = filters.subList(1, filters.size());
                for (NavigableMap subMap : subMaps) {
                    IndexMap indexMap = new IndexMap(subMap);
                    IndexScanner subMapScanner = new IndexScanner(indexMap);
                    LinkedHashSet<NitriteId> subResult = subMapScanner.doScan(remainingFilter, indexScanOrder);
                    nitriteIds.addAll(subResult);
                }
            }
            return nitriteIds;
        } else {
            List<NitriteId> terminalResult = this.indexMap.getTerminalNitriteIds();
            nitriteIds.addAll(terminalResult);
        }
        return nitriteIds;
    }

    private boolean isEmptyList(List<?> list) {
        return list == null || list.isEmpty();
    }

    private boolean isNitriteIdList(List<?> list) {
        Object value = list.get(0);
        return value instanceof NitriteId;
    }

    private boolean isNavigableMapList(List<?> list) {
        Object value = list.get(0);
        return value instanceof NavigableMap;
    }
}

