/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.index;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import org.dizitart.no2.collection.FindPlan;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.DBNull;
import org.dizitart.no2.common.DBValue;
import org.dizitart.no2.common.FieldValues;
import org.dizitart.no2.common.Fields;
import org.dizitart.no2.common.util.IndexUtils;
import org.dizitart.no2.common.util.ObjectUtils;
import org.dizitart.no2.filters.ComparableFilter;
import org.dizitart.no2.index.IndexDescriptor;
import org.dizitart.no2.index.IndexMap;
import org.dizitart.no2.index.IndexScanner;
import org.dizitart.no2.index.NitriteIndex;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.store.NitriteStore;

public class SingleFieldIndex
implements NitriteIndex {
    private final IndexDescriptor indexDescriptor;
    private final NitriteStore<?> nitriteStore;

    public SingleFieldIndex(IndexDescriptor indexDescriptor, NitriteStore<?> nitriteStore) {
        this.indexDescriptor = indexDescriptor;
        this.nitriteStore = nitriteStore;
    }

    @Override
    public void write(FieldValues fieldValues) {
        block3: {
            NitriteMap<DBValue, List<?>> indexMap;
            Object element;
            block5: {
                Object[] array;
                block4: {
                    block2: {
                        Fields fields = fieldValues.getFields();
                        List<String> fieldNames = fields.getFieldNames();
                        String firstField = fieldNames.get(0);
                        element = fieldValues.get(firstField);
                        indexMap = this.findIndexMap();
                        if (element != null) break block2;
                        this.addIndexElement(indexMap, fieldValues, DBNull.getInstance());
                        break block3;
                    }
                    if (!(element instanceof Comparable)) break block4;
                    DBValue dbValue = new DBValue((Comparable)element);
                    this.addIndexElement(indexMap, fieldValues, dbValue);
                    break block3;
                }
                if (!element.getClass().isArray()) break block5;
                for (Object item : array = ObjectUtils.convertToObjectArray(element)) {
                    DBValue dbValue = item == null ? DBNull.getInstance() : new DBValue((Comparable)item);
                    this.addIndexElement(indexMap, fieldValues, dbValue);
                }
                break block3;
            }
            if (!(element instanceof Iterable)) break block3;
            Iterable iterable = (Iterable)element;
            for (Object item : iterable) {
                DBValue dbValue = item == null ? DBNull.getInstance() : new DBValue((Comparable)item);
                this.addIndexElement(indexMap, fieldValues, dbValue);
            }
        }
    }

    @Override
    public void remove(FieldValues fieldValues) {
        block3: {
            NitriteMap<DBValue, List<?>> indexMap;
            Object element;
            block5: {
                Object[] array;
                block4: {
                    block2: {
                        Fields fields = fieldValues.getFields();
                        List<String> fieldNames = fields.getFieldNames();
                        String firstField = fieldNames.get(0);
                        element = fieldValues.get(firstField);
                        indexMap = this.findIndexMap();
                        if (element != null) break block2;
                        this.removeIndexElement(indexMap, fieldValues, DBNull.getInstance());
                        break block3;
                    }
                    if (!(element instanceof Comparable)) break block4;
                    DBValue dbValue = new DBValue((Comparable)element);
                    this.removeIndexElement(indexMap, fieldValues, dbValue);
                    break block3;
                }
                if (!element.getClass().isArray()) break block5;
                for (Object item : array = ObjectUtils.convertToObjectArray(element)) {
                    DBValue dbValue = item == null ? DBNull.getInstance() : new DBValue((Comparable)item);
                    this.removeIndexElement(indexMap, fieldValues, dbValue);
                }
                break block3;
            }
            if (!(element instanceof Iterable)) break block3;
            Iterable iterable = (Iterable)element;
            for (Object item : iterable) {
                DBValue dbValue = item == null ? DBNull.getInstance() : new DBValue((Comparable)item);
                this.removeIndexElement(indexMap, fieldValues, dbValue);
            }
        }
    }

    @Override
    public void drop() {
        NitriteMap<DBValue, List<?>> indexMap = this.findIndexMap();
        indexMap.clear();
        indexMap.drop();
    }

    @Override
    public LinkedHashSet<NitriteId> findNitriteIds(FindPlan findPlan) {
        if (findPlan.getIndexScanFilter() == null) {
            return new LinkedHashSet<NitriteId>();
        }
        NitriteMap<DBValue, List<?>> indexMap = this.findIndexMap();
        return this.scanIndex(findPlan, indexMap);
    }

    private void addIndexElement(NitriteMap<DBValue, List<?>> indexMap, FieldValues fieldValues, DBValue element) {
        List<NitriteId> nitriteIds = indexMap.get(element);
        nitriteIds = this.addNitriteIds(nitriteIds, fieldValues);
        indexMap.put(element, nitriteIds);
    }

    private void removeIndexElement(NitriteMap<DBValue, List<?>> indexMap, FieldValues fieldValues, DBValue element) {
        List<?> nitriteIds = indexMap.get(element);
        if (nitriteIds != null && !nitriteIds.isEmpty()) {
            nitriteIds.remove(fieldValues.getNitriteId());
            if (nitriteIds.size() == 0) {
                indexMap.remove(element);
            } else {
                indexMap.put(element, nitriteIds);
            }
        }
    }

    private NitriteMap<DBValue, List<?>> findIndexMap() {
        String mapName = IndexUtils.deriveIndexMapName(this.indexDescriptor);
        return this.nitriteStore.openMap(mapName, DBValue.class, CopyOnWriteArrayList.class);
    }

    private LinkedHashSet<NitriteId> scanIndex(FindPlan findPlan, NitriteMap<DBValue, List<?>> indexMap) {
        List<ComparableFilter> filters = findPlan.getIndexScanFilter().getFilters();
        IndexMap iMap = new IndexMap(indexMap);
        IndexScanner indexScanner = new IndexScanner(iMap);
        return indexScanner.doScan(filters, findPlan.getIndexScanOrder());
    }

    @Override
    @Generated
    public IndexDescriptor getIndexDescriptor() {
        return this.indexDescriptor;
    }
}

