/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.migration.commands;

import lombok.Generated;
import org.dizitart.no2.Nitrite;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.Fields;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.index.IndexDescriptor;
import org.dizitart.no2.migration.Generator;
import org.dizitart.no2.migration.commands.BaseCommand;

public class AddField
extends BaseCommand {
    private final String collectionName;
    private final String fieldName;
    private final Object defaultValue;

    @Override
    public void execute(Nitrite nitrite) {
        this.initialize(nitrite, this.collectionName);
        IndexDescriptor indexDescriptor = this.operations.findIndex(Fields.withNames(this.fieldName));
        for (Pair pair : this.nitriteMap.entries()) {
            Document document = (Document)pair.getSecond();
            if (this.defaultValue instanceof Generator) {
                Generator generator = (Generator)this.defaultValue;
                document.put(this.fieldName, generator.generate(document));
            } else {
                document.put(this.fieldName, this.defaultValue);
            }
            this.nitriteMap.put((NitriteId)pair.getFirst(), document);
        }
        if (indexDescriptor != null) {
            this.operations.createIndex(Fields.withNames(this.fieldName), indexDescriptor.getIndexType());
        }
    }

    @Generated
    public AddField(String collectionName, String fieldName, Object defaultValue) {
        this.collectionName = collectionName;
        this.fieldName = fieldName;
        this.defaultValue = defaultValue;
    }
}

