/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.repository;

import java.util.Collection;
import org.dizitart.no2.NitriteConfig;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.FindOptions;
import org.dizitart.no2.collection.NitriteCollection;
import org.dizitart.no2.collection.UpdateOptions;
import org.dizitart.no2.collection.events.CollectionEventListener;
import org.dizitart.no2.common.WriteResult;
import org.dizitart.no2.common.meta.Attributes;
import org.dizitart.no2.common.processors.Processor;
import org.dizitart.no2.common.util.ValidationUtils;
import org.dizitart.no2.filters.Filter;
import org.dizitart.no2.index.IndexDescriptor;
import org.dizitart.no2.index.IndexOptions;
import org.dizitart.no2.repository.Cursor;
import org.dizitart.no2.repository.EntityDecorator;
import org.dizitart.no2.repository.ObjectRepository;
import org.dizitart.no2.repository.RepositoryOperations;
import org.dizitart.no2.store.NitriteStore;

class DefaultObjectRepository<T>
implements ObjectRepository<T> {
    private final NitriteCollection collection;
    private final NitriteConfig nitriteConfig;
    private Class<T> type;
    private EntityDecorator<T> entityDecorator;
    private RepositoryOperations operations;

    DefaultObjectRepository(Class<T> type, NitriteCollection collection, NitriteConfig nitriteConfig) {
        this.type = type;
        this.collection = collection;
        this.nitriteConfig = nitriteConfig;
        this.initialize();
    }

    DefaultObjectRepository(EntityDecorator<T> entityDecorator, NitriteCollection collection, NitriteConfig nitriteConfig) {
        this.entityDecorator = entityDecorator;
        this.collection = collection;
        this.nitriteConfig = nitriteConfig;
        this.initialize();
    }

    @Override
    public void addProcessor(Processor processor) {
        ValidationUtils.notNull(processor, "a null processor cannot be added");
        this.collection.addProcessor(processor);
    }

    @Override
    public void createIndex(IndexOptions indexOptions, String ... fields) {
        this.collection.createIndex(indexOptions, fields);
    }

    @Override
    public void rebuildIndex(String ... fields) {
        this.collection.rebuildIndex(fields);
    }

    @Override
    public Collection<IndexDescriptor> listIndices() {
        return this.collection.listIndices();
    }

    @Override
    public boolean hasIndex(String ... fields) {
        return this.collection.hasIndex(fields);
    }

    @Override
    public boolean isIndexing(String ... fields) {
        return this.collection.isIndexing(fields);
    }

    @Override
    public void dropIndex(String ... fields) {
        this.collection.dropIndex(fields);
    }

    @Override
    public void dropAllIndices() {
        this.collection.dropAllIndices();
    }

    @Override
    public WriteResult insert(T[] elements) {
        ValidationUtils.notNull(elements, "a null object cannot be inserted");
        ValidationUtils.containsNull(elements, "a null object cannot be inserted");
        return this.collection.insert(this.operations.toDocuments(elements));
    }

    @Override
    public WriteResult update(T element, boolean insertIfAbsent) {
        ValidationUtils.notNull(element, "a null object cannot be used for update");
        return this.update(this.operations.createUniqueFilter(element), element, UpdateOptions.updateOptions(insertIfAbsent, true));
    }

    @Override
    public WriteResult update(Filter filter, T update, UpdateOptions updateOptions) {
        ValidationUtils.notNull(update, "a null object cannot be used for update");
        Document updateDocument = this.operations.toDocument(update, true);
        if (updateOptions == null || !updateOptions.isInsertIfAbsent()) {
            this.operations.removeNitriteId(updateDocument);
        }
        return this.collection.update(this.operations.asObjectFilter(filter), updateDocument, updateOptions);
    }

    @Override
    public WriteResult update(Filter filter, Document update, boolean justOnce) {
        ValidationUtils.notNull(update, "a null document cannot be used for update");
        this.operations.removeNitriteId(update);
        this.operations.serializeFields(update);
        return this.collection.update(this.operations.asObjectFilter(filter), update, UpdateOptions.updateOptions(false, justOnce));
    }

    @Override
    public WriteResult remove(T element) {
        ValidationUtils.notNull(element, "a null object cannot be removed");
        return this.remove((T)this.operations.createUniqueFilter(element));
    }

    @Override
    public WriteResult remove(Filter filter, boolean justOne) {
        return this.collection.remove(this.operations.asObjectFilter(filter), justOne);
    }

    @Override
    public void clear() {
        this.collection.clear();
    }

    @Override
    public Cursor<T> find(Filter filter, FindOptions findOptions) {
        return this.operations.find(filter, findOptions, this.getType());
    }

    @Override
    public <I> T getById(I id) {
        Filter idFilter = this.operations.createIdFilter(id);
        return this.find(idFilter).firstOrNull();
    }

    @Override
    public void drop() {
        this.collection.drop();
    }

    @Override
    public boolean isDropped() {
        return this.collection.isDropped();
    }

    @Override
    public boolean isOpen() {
        return this.collection.isOpen();
    }

    @Override
    public void close() {
        this.collection.close();
    }

    @Override
    public long size() {
        return this.collection.size();
    }

    @Override
    public NitriteStore<?> getStore() {
        return this.collection.getStore();
    }

    @Override
    public void subscribe(CollectionEventListener listener) {
        this.collection.subscribe(listener);
    }

    @Override
    public void unsubscribe(CollectionEventListener listener) {
        this.collection.unsubscribe(listener);
    }

    @Override
    public Attributes getAttributes() {
        return this.collection.getAttributes();
    }

    @Override
    public void setAttributes(Attributes attributes) {
        this.collection.setAttributes(attributes);
    }

    @Override
    public Class<T> getType() {
        if (this.entityDecorator != null) {
            return this.entityDecorator.getEntityType();
        }
        return this.type;
    }

    @Override
    public NitriteCollection getDocumentCollection() {
        return this.collection;
    }

    private void initialize() {
        this.operations = this.entityDecorator != null ? new RepositoryOperations(this.entityDecorator, this.collection, this.nitriteConfig) : new RepositoryOperations(this.type, this.collection, this.nitriteConfig);
        this.operations.scanIndexes();
        this.operations.createIndexes();
    }
}

