/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.repository;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.dizitart.no2.NitriteConfig;
import org.dizitart.no2.collection.CollectionFactory;
import org.dizitart.no2.collection.NitriteCollection;
import org.dizitart.no2.common.util.ObjectUtils;
import org.dizitart.no2.common.util.StringUtils;
import org.dizitart.no2.common.util.ValidationUtils;
import org.dizitart.no2.exceptions.NitriteIOException;
import org.dizitart.no2.exceptions.ValidationException;
import org.dizitart.no2.repository.DefaultObjectRepository;
import org.dizitart.no2.repository.EntityDecorator;
import org.dizitart.no2.repository.ObjectRepository;
import org.dizitart.no2.store.NitriteStore;
import org.dizitart.no2.store.StoreCatalog;

public class RepositoryFactory {
    private final Map<String, ObjectRepository<?>> repositoryMap;
    private final CollectionFactory collectionFactory;
    private final ReentrantLock lock;

    public RepositoryFactory(CollectionFactory collectionFactory) {
        this.collectionFactory = collectionFactory;
        this.repositoryMap = new HashMap();
        this.lock = new ReentrantLock();
    }

    public <T> ObjectRepository<T> getRepository(NitriteConfig nitriteConfig, Class<T> type) {
        return this.getRepository(nitriteConfig, type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ObjectRepository<T> getRepository(NitriteConfig nitriteConfig, Class<T> type, String key) {
        if (type == null) {
            throw new ValidationException("type cannot be null");
        }
        if (nitriteConfig == null) {
            throw new ValidationException("nitriteConfig cannot be null");
        }
        String collectionName = ObjectUtils.findRepositoryName(type, key);
        try {
            this.lock.lock();
            if (this.repositoryMap.containsKey(collectionName)) {
                ObjectRepository<?> repository = this.repositoryMap.get(collectionName);
                if (repository.isDropped() || !repository.isOpen()) {
                    this.repositoryMap.remove(collectionName);
                    ObjectRepository<T> objectRepository = this.createRepository(nitriteConfig, type, collectionName, key);
                    return objectRepository;
                }
                ObjectRepository<?> objectRepository = repository;
                return objectRepository;
            }
            ObjectRepository<T> objectRepository = this.createRepository(nitriteConfig, type, collectionName, key);
            return objectRepository;
        }
        finally {
            this.lock.unlock();
        }
    }

    public <T> ObjectRepository<T> getRepository(NitriteConfig nitriteConfig, EntityDecorator<T> entityDecorator) {
        return this.getRepository(nitriteConfig, entityDecorator, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ObjectRepository<T> getRepository(NitriteConfig nitriteConfig, EntityDecorator<T> entityDecorator, String key) {
        if (entityDecorator == null) {
            throw new ValidationException("entityDecorator cannot be null");
        }
        if (nitriteConfig == null) {
            throw new ValidationException("nitriteConfig cannot be null");
        }
        String collectionName = ObjectUtils.findRepositoryNameByDecorator(entityDecorator, key);
        try {
            this.lock.lock();
            if (this.repositoryMap.containsKey(collectionName)) {
                ObjectRepository<?> repository = this.repositoryMap.get(collectionName);
                if (repository.isDropped() || !repository.isOpen()) {
                    this.repositoryMap.remove(collectionName);
                    ObjectRepository<T> objectRepository = this.createRepositoryByDecorator(nitriteConfig, entityDecorator, collectionName, key);
                    return objectRepository;
                }
                ObjectRepository<?> objectRepository = repository;
                return objectRepository;
            }
            ObjectRepository<T> objectRepository = this.createRepositoryByDecorator(nitriteConfig, entityDecorator, collectionName, key);
            return objectRepository;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() {
        try {
            this.lock.lock();
            for (ObjectRepository<?> repository : this.repositoryMap.values()) {
                repository.close();
            }
            this.repositoryMap.clear();
        }
        catch (Exception e) {
            throw new NitriteIOException("Failed to clear an object repository", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private <T> ObjectRepository<T> createRepository(NitriteConfig nitriteConfig, Class<T> type, String collectionName, String key) {
        NitriteStore<?> store = nitriteConfig.getNitriteStore();
        ValidationUtils.validateRepositoryType(type, nitriteConfig);
        if (store.getCollectionNames().contains(collectionName)) {
            throw new ValidationException("A collection with same entity name already exists");
        }
        NitriteCollection nitriteCollection = this.collectionFactory.getCollection(collectionName, nitriteConfig, false);
        DefaultObjectRepository<T> repository = new DefaultObjectRepository<T>(type, nitriteCollection, nitriteConfig);
        this.repositoryMap.put(collectionName, repository);
        this.writeCatalog(store, collectionName, key);
        return repository;
    }

    private <T> ObjectRepository<T> createRepositoryByDecorator(NitriteConfig nitriteConfig, EntityDecorator<T> entityDecorator, String collectionName, String key) {
        NitriteStore<?> store = nitriteConfig.getNitriteStore();
        if (store.getCollectionNames().contains(collectionName)) {
            throw new ValidationException("A collection with same entity name already exists");
        }
        ValidationUtils.validateRepositoryType(entityDecorator.getEntityType(), nitriteConfig);
        NitriteCollection nitriteCollection = this.collectionFactory.getCollection(collectionName, nitriteConfig, false);
        DefaultObjectRepository<T> repository = new DefaultObjectRepository<T>(entityDecorator, nitriteCollection, nitriteConfig);
        this.repositoryMap.put(collectionName, repository);
        this.writeCatalog(store, collectionName, key);
        return repository;
    }

    private void writeCatalog(NitriteStore<?> store, String name, String key) {
        StoreCatalog storeCatalog = store.getCatalog();
        if (!storeCatalog.hasEntry(name)) {
            if (StringUtils.isNullOrEmpty(key)) {
                storeCatalog.writeRepositoryEntry(name);
            } else {
                storeCatalog.writeKeyedRepositoryEntry(name);
            }
        }
    }
}

