/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.transaction;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.RecordStream;
import org.dizitart.no2.common.util.SpatialKey;
import org.dizitart.no2.index.BoundingBox;
import org.dizitart.no2.store.NitriteRTree;

class TransactionalRTree<Key extends BoundingBox, Value>
implements NitriteRTree<Key, Value> {
    private final Map<SpatialKey, Key> map = new HashMap<SpatialKey, Key>();
    private final NitriteRTree<Key, Value> primary;

    public TransactionalRTree(NitriteRTree<Key, Value> primary) {
        this.primary = primary;
    }

    @Override
    public void add(Key key, NitriteId nitriteId) {
        if (nitriteId != null && nitriteId.getIdValue() != null) {
            SpatialKey spatialKey = this.getKey(key, Long.parseLong(nitriteId.getIdValue()));
            this.map.put(spatialKey, key);
        }
    }

    @Override
    public void remove(Key key, NitriteId nitriteId) {
        if (nitriteId != null && nitriteId.getIdValue() != null) {
            SpatialKey spatialKey = this.getKey(key, Long.parseLong(nitriteId.getIdValue()));
            this.map.remove(spatialKey);
        }
    }

    @Override
    public RecordStream<NitriteId> findIntersectingKeys(Key key) {
        SpatialKey spatialKey = this.getKey(key, 0L);
        HashSet<NitriteId> set = new HashSet<NitriteId>();
        for (SpatialKey sk : this.map.keySet()) {
            if (!this.isOverlap(sk, spatialKey)) continue;
            set.add(NitriteId.createId(Long.toString(sk.getId())));
        }
        RecordStream<NitriteId> primaryRecords = this.primary.findIntersectingKeys(key);
        return RecordStream.fromCombined(primaryRecords, set);
    }

    @Override
    public RecordStream<NitriteId> findContainedKeys(Key key) {
        SpatialKey spatialKey = this.getKey(key, 0L);
        HashSet<NitriteId> set = new HashSet<NitriteId>();
        for (SpatialKey sk : this.map.keySet()) {
            if (!this.isInside(sk, spatialKey)) continue;
            set.add(NitriteId.createId(Long.toString(sk.getId())));
        }
        RecordStream<NitriteId> primaryRecords = this.primary.findContainedKeys(key);
        return RecordStream.fromCombined(primaryRecords, set);
    }

    @Override
    public long size() {
        return this.map.size();
    }

    private boolean isOverlap(SpatialKey a, SpatialKey b) {
        if (a.isNull() || b.isNull()) {
            return false;
        }
        for (int i = 0; i < 2; ++i) {
            if (!(a.max(i) < b.min(i)) && !(a.min(i) > b.max(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isInside(SpatialKey a, SpatialKey b) {
        if (a.isNull() || b.isNull()) {
            return false;
        }
        for (int i = 0; i < 2; ++i) {
            if (!(a.min(i) <= b.min(i)) && !(a.max(i) >= b.max(i))) continue;
            return false;
        }
        return true;
    }

    private SpatialKey getKey(Key key, long id) {
        if (key == null || ((BoundingBox)key).equals(BoundingBox.EMPTY)) {
            return new SpatialKey(id, new float[0]);
        }
        return new SpatialKey(id, ((BoundingBox)key).getMinX(), ((BoundingBox)key).getMaxX(), ((BoundingBox)key).getMinY(), ((BoundingBox)key).getMaxY());
    }

    @Override
    public void close() {
        this.map.clear();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public void drop() {
        this.map.clear();
    }
}

