/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.collection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import lombok.Generated;
import org.dizitart.no2.collection.SnowflakeIdGenerator;
import org.dizitart.no2.exceptions.InvalidIdException;

public final class NitriteId
implements Comparable<NitriteId>,
Serializable {
    private static final long serialVersionUID = 1477462375L;
    private static final SnowflakeIdGenerator generator = new SnowflakeIdGenerator();
    private long _idValue;

    private NitriteId() {
        this._idValue = generator.getId();
    }

    private NitriteId(String value) {
        this._idValue = Long.parseLong(value);
    }

    private NitriteId(long value) {
        this._idValue = value;
    }

    public static NitriteId newId() {
        return new NitriteId();
    }

    public static NitriteId createId(String value) {
        NitriteId.validId(value);
        return new NitriteId(value);
    }

    public static NitriteId createId(long value) {
        NitriteId.validId(value);
        return new NitriteId(value);
    }

    public static boolean validId(Object value) {
        if (value == null) {
            throw new InvalidIdException("id cannot be null");
        }
        try {
            Long.parseLong(value.toString());
            return true;
        }
        catch (Exception e) {
            throw new InvalidIdException("id must be a string representation of 64bit integer number " + String.valueOf(value));
        }
    }

    public long getIdValue() {
        return this._idValue;
    }

    @Override
    public int compareTo(NitriteId other) {
        return Long.compare(this._idValue, other._idValue);
    }

    public String toString() {
        return "[" + this._idValue + "]NO\u2082";
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeUTF(Long.toString(this._idValue));
    }

    private void readObject(ObjectInputStream stream) throws IOException {
        this._idValue = Long.parseLong(stream.readUTF());
    }

    @Generated
    public long get_idValue() {
        return this._idValue;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NitriteId)) {
            return false;
        }
        NitriteId other = (NitriteId)o;
        return this.get_idValue() == other.get_idValue();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $_idValue = this.get_idValue();
        result = result * 59 + (int)($_idValue >>> 32 ^ $_idValue);
        return result;
    }
}

