/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.collection.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.dizitart.no2.collection.FindOptions;
import org.dizitart.no2.collection.FindPlan;
import org.dizitart.no2.common.SortOrder;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.common.util.Iterables;
import org.dizitart.no2.exceptions.FilterException;
import org.dizitart.no2.filters.AndFilter;
import org.dizitart.no2.filters.ComparableFilter;
import org.dizitart.no2.filters.EqualsFilter;
import org.dizitart.no2.filters.Filter;
import org.dizitart.no2.filters.IndexOnlyFilter;
import org.dizitart.no2.filters.IndexScanFilter;
import org.dizitart.no2.filters.OrFilter;
import org.dizitart.no2.filters.TextFilter;
import org.dizitart.no2.index.IndexDescriptor;

class FindOptimizer {
    FindOptimizer() {
    }

    public FindPlan optimize(Filter filter, FindOptions findOptions, Collection<IndexDescriptor> indexDescriptors) {
        FindPlan findPlan = this.createFilterPlan(indexDescriptors, filter);
        this.readSortOption(findOptions, findPlan);
        this.readLimitOption(findOptions, findPlan);
        if (findOptions != null) {
            findPlan.setCollator(findOptions.collator());
            findPlan.setDistinct(findOptions.distinct());
        }
        return findPlan;
    }

    private FindPlan createFilterPlan(Collection<IndexDescriptor> indexDescriptors, Filter filter) {
        if (filter instanceof AndFilter) {
            List<Filter> filters = this.flattenAndFilter((AndFilter)filter);
            return this.createAndPlan(indexDescriptors, filters);
        }
        if (filter instanceof OrFilter) {
            return this.createOrPlan(indexDescriptors, ((OrFilter)filter).getFilters());
        }
        List<Filter> filters = Collections.singletonList(filter);
        return this.createAndPlan(indexDescriptors, filters);
    }

    private List<Filter> flattenAndFilter(AndFilter andFilter) {
        ArrayList<Filter> flattenedFilters = new ArrayList<Filter>();
        if (andFilter != null) {
            for (Filter filter : andFilter.getFilters()) {
                if (filter instanceof AndFilter) {
                    List<Filter> filters = this.flattenAndFilter((AndFilter)filter);
                    flattenedFilters.addAll(filters);
                    continue;
                }
                flattenedFilters.add(filter);
            }
        }
        return flattenedFilters;
    }

    private FindPlan createOrPlan(Collection<IndexDescriptor> indexDescriptors, List<Filter> filters) {
        FindPlan findPlan = new FindPlan();
        HashSet<Filter> flattenedFilter = new HashSet<Filter>();
        for (Filter filter : filters) {
            if (filter instanceof OrFilter) {
                flattenedFilter.addAll(((OrFilter)filter).getFilters());
                continue;
            }
            flattenedFilter.add(filter);
        }
        for (Filter filter : flattenedFilter) {
            FindPlan subPlan = this.createFilterPlan(indexDescriptors, filter);
            findPlan.getSubPlans().add(subPlan);
        }
        for (FindPlan plan : findPlan.getSubPlans()) {
            if (plan.getIndexDescriptor() != null) continue;
            findPlan.getSubPlans().clear();
            findPlan.setCollectionScanFilter(Filter.or(filters.toArray(new Filter[0])));
            return findPlan;
        }
        return findPlan;
    }

    private FindPlan createAndPlan(Collection<IndexDescriptor> indexDescriptors, List<Filter> filters) {
        FindPlan findPlan = new FindPlan();
        LinkedHashSet<ComparableFilter> indexScanFilters = new LinkedHashSet<ComparableFilter>();
        LinkedHashSet<Filter> columnScanFilters = new LinkedHashSet<Filter>();
        this.planForIdFilter(findPlan, filters);
        this.planForIndexOnlyFilters(findPlan, indexScanFilters, indexDescriptors, filters);
        if (findPlan.getByIdFilter() == null && indexScanFilters.isEmpty()) {
            this.planForIndexScanningFilters(findPlan, indexScanFilters, indexDescriptors, filters);
        }
        this.planForCollectionScanningFilters(findPlan, indexScanFilters, columnScanFilters, filters);
        if (indexScanFilters.size() == 1) {
            IndexScanFilter indexScanFilter = new IndexScanFilter(Collections.singletonList(Iterables.firstOrNull(indexScanFilters)));
            findPlan.setIndexScanFilter(indexScanFilter);
        } else if (indexScanFilters.size() > 1) {
            IndexScanFilter indexScanFilter = new IndexScanFilter(indexScanFilters);
            findPlan.setIndexScanFilter(indexScanFilter);
        }
        if (columnScanFilters.size() == 1) {
            findPlan.setCollectionScanFilter(Iterables.firstOrNull(columnScanFilters));
        } else if (columnScanFilters.size() > 1) {
            Filter andFilter = Filter.and(columnScanFilters.toArray(new Filter[0]));
            findPlan.setCollectionScanFilter(andFilter);
        }
        return findPlan;
    }

    private void planForIdFilter(FindPlan findPlan, List<Filter> filters) {
        for (Filter filter : filters) {
            EqualsFilter equalsFilter;
            if (!(filter instanceof EqualsFilter) || !(equalsFilter = (EqualsFilter)filter).getField().equals("_id")) continue;
            findPlan.setByIdFilter(equalsFilter);
            break;
        }
    }

    private void planForIndexOnlyFilters(FindPlan findPlan, Set<ComparableFilter> indexScanFilters, Collection<IndexDescriptor> indexDescriptors, List<Filter> filters) {
        ArrayList<IndexOnlyFilter> indexOnlyFilters = new ArrayList<IndexOnlyFilter>();
        for (Filter filter : filters) {
            if (!(filter instanceof IndexOnlyFilter)) continue;
            IndexOnlyFilter indexScanFilter = (IndexOnlyFilter)filter;
            if (this.isCompatibleFilter(indexOnlyFilters, indexScanFilter)) {
                indexOnlyFilters.add(indexScanFilter);
                continue;
            }
            throw new FilterException("A query can not have multiple index only filters");
        }
        if (!indexOnlyFilters.isEmpty()) {
            IndexOnlyFilter anyFilter = (IndexOnlyFilter)indexOnlyFilters.get(0);
            for (IndexDescriptor indexDescriptor : indexDescriptors) {
                if (!anyFilter.supportedIndexType().equals(indexDescriptor.getIndexType())) continue;
                findPlan.setIndexDescriptor(indexDescriptor);
                indexScanFilters.addAll(indexOnlyFilters);
                break;
            }
            if (findPlan.getIndexDescriptor() == null) {
                throw new FilterException(anyFilter.getField() + " is not indexed with " + anyFilter.supportedIndexType() + " index");
            }
        }
    }

    private boolean isCompatibleFilter(List<IndexOnlyFilter> indexOnlyFilters, IndexOnlyFilter filter) {
        if (indexOnlyFilters.isEmpty()) {
            return true;
        }
        IndexOnlyFilter comparableFilter = indexOnlyFilters.get(0);
        return comparableFilter.canBeGrouped(filter);
    }

    private void planForIndexScanningFilters(FindPlan findPlan, Set<ComparableFilter> indexScanFilters, Collection<IndexDescriptor> indexDescriptors, List<Filter> filters) {
        TreeMap indexFilterMap = new TreeMap(Collections.reverseOrder());
        for (IndexDescriptor indexDescriptor : indexDescriptors) {
            List<String> fieldNames = indexDescriptor.getFields().getFieldNames();
            ArrayList<ComparableFilter> indexedFilters = new ArrayList<ComparableFilter>();
            for (String fieldName : fieldNames) {
                boolean matchFound = false;
                for (Filter filter : filters) {
                    String filterFieldName;
                    if (!(filter instanceof ComparableFilter) || !(filterFieldName = ((ComparableFilter)filter).getField()).equals(fieldName)) continue;
                    indexedFilters.add((ComparableFilter)filter);
                    matchFound = true;
                    break;
                }
                if (matchFound) continue;
                break;
            }
            if (indexedFilters.isEmpty()) continue;
            indexFilterMap.put(indexDescriptor, indexedFilters);
        }
        for (Map.Entry entry : indexFilterMap.entrySet()) {
            if (((List)entry.getValue()).size() <= indexScanFilters.size()) continue;
            indexScanFilters.addAll((Collection)entry.getValue());
            findPlan.setIndexDescriptor((IndexDescriptor)entry.getKey());
        }
    }

    private void planForCollectionScanningFilters(FindPlan findPlan, Set<ComparableFilter> indexScanFilters, Set<Filter> columnScanFilters, List<Filter> filters) {
        for (Filter filter : filters) {
            if (filter instanceof ComparableFilter && indexScanFilters.contains(filter) || filter == findPlan.getByIdFilter()) continue;
            columnScanFilters.add(filter);
        }
        if (indexScanFilters.isEmpty()) {
            this.validateCollectionScanFilters(columnScanFilters);
        }
    }

    private void validateCollectionScanFilters(Collection<Filter> filters) {
        for (Filter filter : filters) {
            if (filter instanceof IndexOnlyFilter) {
                throw new FilterException("Collection scan is not supported for the filter " + String.valueOf(filter));
            }
            if (!(filter instanceof TextFilter)) continue;
            throw new FilterException(((TextFilter)filter).getField() + " is not full-text indexed");
        }
    }

    private void readSortOption(FindOptions findOptions, FindPlan findPlan) {
        IndexDescriptor indexDescriptor = findPlan.getIndexDescriptor();
        if (findOptions != null && findOptions.orderBy() != null) {
            List<Pair<String, SortOrder>> findSortSpec = findOptions.orderBy().getSortingOrders();
            if (indexDescriptor != null) {
                List<String> indexedFieldNames = indexDescriptor.getFields().getFieldNames();
                boolean canUseIndex = false;
                HashMap<String, Boolean> indexScanOrder = new HashMap<String, Boolean>();
                if (indexedFieldNames.size() >= findSortSpec.size()) {
                    int length = findSortSpec.size();
                    for (int i = 0; i < length; ++i) {
                        Pair<String, SortOrder> findPair;
                        String indexFieldName = indexedFieldNames.get(i);
                        if (!indexFieldName.equals((findPair = findSortSpec.get(i)).getFirst())) {
                            canUseIndex = false;
                            break;
                        }
                        canUseIndex = true;
                        boolean reverseScan = false;
                        SortOrder findSortOrder = findPair.getSecond();
                        if (findSortOrder != SortOrder.Ascending) {
                            reverseScan = true;
                        }
                        indexScanOrder.put(indexFieldName, reverseScan);
                    }
                }
                if (canUseIndex) {
                    findPlan.setIndexScanOrder(indexScanOrder);
                } else {
                    findPlan.setBlockingSortOrder(findSortSpec);
                }
            } else {
                findPlan.setBlockingSortOrder(findSortSpec);
            }
        }
    }

    private void readLimitOption(FindOptions findOptions, FindPlan findPlan) {
        if (findOptions != null) {
            findPlan.setLimit(findOptions.limit());
            findPlan.setSkip(findOptions.skip());
        }
    }
}

