/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.common.event;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.dizitart.no2.common.concurrent.ThreadPoolManager;
import org.dizitart.no2.common.event.EventBus;
import org.dizitart.no2.common.util.StringUtils;
import org.dizitart.no2.exceptions.InvalidOperationException;

public abstract class NitriteEventBus<EventInfo, EventListener>
implements EventBus<EventInfo, EventListener> {
    private final Map<String, EventListener> listeners = new ConcurrentHashMap<String, EventListener>();
    private ExecutorService eventExecutor;

    @Override
    public String register(EventListener eventListener) {
        if (eventListener != null) {
            String subscriptionId = UUID.randomUUID().toString();
            this.listeners.put(subscriptionId, eventListener);
            return subscriptionId;
        }
        throw new InvalidOperationException("event listener cannot be null");
    }

    @Override
    public void deregister(String subscription) {
        if (!StringUtils.isNullOrEmpty(subscription)) {
            this.listeners.remove(subscription);
        }
    }

    @Override
    public void close() {
        this.listeners.clear();
        if (this.eventExecutor != null) {
            this.eventExecutor.shutdown();
        }
    }

    protected ExecutorService getEventExecutor() {
        if (this.eventExecutor == null || this.eventExecutor.isShutdown() || this.eventExecutor.isTerminated()) {
            this.eventExecutor = ThreadPoolManager.workerPool();
        }
        return this.eventExecutor;
    }

    protected Set<EventListener> getListeners() {
        return new HashSet<EventListener>(this.listeners.values());
    }
}

