/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.common.util;

import java.util.ArrayList;
import java.util.Objects;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.common.FieldValues;
import org.dizitart.no2.common.Fields;
import org.dizitart.no2.common.mapper.NitriteMapper;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.common.util.ObjectUtils;
import org.dizitart.no2.filters.Filter;

public class DocumentUtils {
    private DocumentUtils() {
    }

    public static boolean isRecent(Document recent, Document older) {
        if (Objects.deepEquals(recent.getRevision(), older.getRevision())) {
            return recent.getLastModifiedSinceEpoch() >= older.getLastModifiedSinceEpoch();
        }
        return recent.getRevision() > older.getRevision();
    }

    public static Filter createUniqueFilter(Document document) {
        return Filter.byId(document.getId());
    }

    public static <T> Document skeletonDocument(NitriteMapper nitriteMapper, Class<T> type) {
        Object dummy = ObjectUtils.newInstance(type, true, nitriteMapper);
        Document document = (Document)nitriteMapper.tryConvert(dummy, Document.class);
        return DocumentUtils.removeValues(document);
    }

    public static boolean isSimilar(Document document, Document other, String ... fields) {
        boolean result = true;
        if (document == null && other != null) {
            return false;
        }
        if (document != null && other == null) {
            return false;
        }
        if (document == null) {
            return true;
        }
        for (String field : fields) {
            result = result && Objects.deepEquals(document.get(field), other.get(field));
        }
        return result;
    }

    public static FieldValues getValues(Document document, Fields fields) {
        FieldValues fieldValues = new FieldValues();
        fieldValues.setNitriteId(document.getId());
        fieldValues.setFields(fields);
        fieldValues.setValues(new ArrayList<Pair<String, Object>>());
        for (String field : fields.getFieldNames()) {
            Object value = document.get(field);
            fieldValues.getValues().add(new Pair<String, Object>(field, value));
        }
        return fieldValues;
    }

    public static boolean isAffectedByUpdate(Fields fields, Document updatedFields) {
        for (String field : fields.getFieldNames()) {
            if (!updatedFields.containsKey(field)) continue;
            return true;
        }
        return false;
    }

    private static Document removeValues(Document document) {
        if (document == null) {
            return null;
        }
        Document newDoc = Document.createDocument();
        for (Pair entry : document) {
            if (entry.getSecond() instanceof Document) {
                newDoc.put((String)entry.getFirst(), DocumentUtils.removeValues((Document)entry.getSecond()));
                continue;
            }
            newDoc.put((String)entry.getFirst(), null);
        }
        return newDoc;
    }
}

