/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.filters;

import java.util.List;
import java.util.NavigableMap;
import lombok.Generated;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.mapper.NitriteMapper;
import org.dizitart.no2.common.util.ValidationUtils;
import org.dizitart.no2.filters.NitriteFilter;

public abstract class FieldBasedFilter
extends NitriteFilter {
    private String field;
    private Object value;
    private boolean processed = false;

    protected FieldBasedFilter(String field, Object value) {
        this.field = field;
        this.value = value;
    }

    public Object getValue() {
        if (this.processed) {
            return this.value;
        }
        if (this.value == null) {
            return null;
        }
        if (this.getObjectFilter().booleanValue()) {
            NitriteMapper nitriteMapper = this.getNitriteConfig().nitriteMapper();
            this.validateSearchTerm(nitriteMapper, this.field, this.value);
            if (this.value instanceof Comparable) {
                this.value = nitriteMapper.tryConvert(this.value, Comparable.class);
            }
        }
        this.processed = true;
        return this.value;
    }

    protected void validateSearchTerm(NitriteMapper nitriteMapper, String field, Object value) {
        ValidationUtils.notNull(field, "field cannot be null");
        ValidationUtils.notEmpty(field, "field cannot be empty");
    }

    protected void processIndexValue(Object value, List<NavigableMap<Comparable<?>, Object>> subMap, List<NitriteId> nitriteIds) {
        if (value instanceof List) {
            List result = (List)value;
            nitriteIds.addAll(result);
        }
        if (value instanceof NavigableMap) {
            subMap.add((NavigableMap)value);
        }
    }

    @Generated
    public String getField() {
        return this.field;
    }

    @Generated
    public void setField(String field) {
        this.field = field;
    }

    @Generated
    public void setValue(Object value) {
        this.value = value;
    }

    @Generated
    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    @Generated
    public String toString() {
        return "FieldBasedFilter(field=" + this.getField() + ", value=" + String.valueOf(this.getValue()) + ", processed=" + this.processed + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FieldBasedFilter)) {
            return false;
        }
        FieldBasedFilter other = (FieldBasedFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.processed != other.processed) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FieldBasedFilter;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.processed ? 79 : 97);
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

